/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.task;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.samza.SamzaException;
import org.apache.samza.container.TaskName;
import org.apache.samza.system.IncomingMessageEnvelope;
import org.apache.samza.task.ReadableCoordinator;
import org.apache.samza.task.TaskCallbackImpl;
import org.apache.samza.task.TaskCallbackListener;
import org.apache.samza.util.HighResolutionClock;
import org.apache.samza.util.Util;

class TaskCallbackManager {
    private long seqNum = 0L;
    private final TaskCallbacks completedCallbacks = new TaskCallbacks();
    private final ScheduledExecutorService timer;
    private final TaskCallbackListener listener;
    private final long timeout;
    private final int maxConcurrency;
    private final HighResolutionClock clock;

    public TaskCallbackManager(TaskCallbackListener listener, ScheduledExecutorService timer, long timeout, int maxConcurrency, HighResolutionClock clock) {
        this.listener = listener;
        this.timer = timer;
        this.timeout = timeout;
        this.maxConcurrency = maxConcurrency;
        this.clock = clock;
    }

    public TaskCallbackImpl createCallback(TaskName taskName, IncomingMessageEnvelope envelope, ReadableCoordinator coordinator) {
        final TaskCallbackImpl callback = new TaskCallbackImpl(this.listener, taskName, envelope, coordinator, this.seqNum++, this.clock.nanoTime());
        if (this.timer != null) {
            Runnable timerTask = new Runnable(){

                @Override
                public void run() {
                    Util.logThreadDump("Thread dump at task callback timeout");
                    String msg = "Callback for task {} " + callback.taskName + " timed out after " + TaskCallbackManager.this.timeout + " ms.";
                    callback.failure((Throwable)new SamzaException(msg));
                }
            };
            ScheduledFuture<?> scheduledFuture = this.timer.schedule(timerTask, this.timeout, TimeUnit.MILLISECONDS);
            callback.setScheduledFuture(scheduledFuture);
        }
        return callback;
    }

    public List<TaskCallbackImpl> updateCallback(TaskCallbackImpl callback) {
        if (this.maxConcurrency > 1) {
            return this.completedCallbacks.update(callback);
        }
        return ImmutableList.of((Object)callback);
    }

    private static final class TaskCallbacks {
        private final Queue<TaskCallbackImpl> callbacks = new PriorityQueue<TaskCallbackImpl>();
        private final Object lock = new Object();
        private long nextSeqNum = 0L;

        private TaskCallbacks() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<TaskCallbackImpl> update(TaskCallbackImpl cb) {
            Object object = this.lock;
            synchronized (object) {
                this.callbacks.add(cb);
                ArrayList<TaskCallbackImpl> callbacksToUpdate = new ArrayList<TaskCallbackImpl>();
                while (!this.callbacks.isEmpty() && this.callbacks.peek().matchSeqNum(this.nextSeqNum)) {
                    ++this.nextSeqNum;
                    TaskCallbackImpl callback = this.callbacks.poll();
                    callbacksToUpdate.add(callback);
                    if (!callback.coordinator.commitRequest().isDefined()) continue;
                    break;
                }
                return callbacksToUpdate;
            }
        }
    }
}

