/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.task;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.samza.SamzaException;
import org.apache.samza.container.TaskName;
import org.apache.samza.system.IncomingMessageEnvelope;
import org.apache.samza.task.ReadableCoordinator;
import org.apache.samza.task.TaskCallback;
import org.apache.samza.task.TaskCallbackListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TaskCallbackImpl
implements TaskCallback,
Comparable<TaskCallbackImpl> {
    private static final Logger log = LoggerFactory.getLogger(TaskCallbackImpl.class);
    final TaskName taskName;
    final IncomingMessageEnvelope envelope;
    final ReadableCoordinator coordinator;
    final long timeCreatedNs;
    private final AtomicBoolean isComplete = new AtomicBoolean(false);
    private final TaskCallbackListener listener;
    private ScheduledFuture scheduledFuture = null;
    private final long seqNum;

    public TaskCallbackImpl(TaskCallbackListener listener, TaskName taskName, IncomingMessageEnvelope envelope, ReadableCoordinator coordinator, long seqNum, long timeCreatedNs) {
        this.listener = listener;
        this.taskName = taskName;
        this.envelope = envelope;
        this.coordinator = coordinator;
        this.seqNum = seqNum;
        this.timeCreatedNs = timeCreatedNs;
    }

    public void complete() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        log.trace("Callback complete for task {}, ssp {}, offset {}.", new Object[]{this.taskName, this.envelope.getSystemStreamPartition(), this.envelope.getOffset()});
        if (this.isComplete.compareAndSet(false, true)) {
            this.listener.onComplete(this);
        } else {
            String msg = String.format("Callback complete was invoked after completion for task %s, ssp %s, offset %s.", this.taskName, this.envelope.getSystemStreamPartition(), this.envelope.getOffset());
            this.listener.onFailure(this, new IllegalStateException(msg));
        }
    }

    public void failure(Throwable t) {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        if (this.isComplete.compareAndSet(false, true)) {
            String msg = String.format("Callback failed for task %s, ssp %s, offset %s.", this.taskName, this.envelope.getSystemStreamPartition(), this.envelope.getOffset());
            this.listener.onFailure(this, (Throwable)new SamzaException(msg, t));
        } else {
            String msg = String.format("Task callback failure was invoked after completion for task %s, ssp %s, offset %s.", this.taskName, this.envelope.getSystemStreamPartition(), this.envelope.getOffset());
            this.listener.onFailure(this, new IllegalStateException(msg, t));
        }
    }

    void setScheduledFuture(ScheduledFuture scheduledFuture) {
        this.scheduledFuture = scheduledFuture;
    }

    @Override
    public int compareTo(TaskCallbackImpl callback) {
        return Long.compare(this.seqNum, callback.seqNum);
    }

    boolean matchSeqNum(long seqNum) {
        return this.seqNum == seqNum;
    }
}

