/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.task;

import org.apache.samza.context.Context;
import org.apache.samza.operators.OperatorSpecGraph;
import org.apache.samza.operators.impl.InputOperatorImpl;
import org.apache.samza.operators.impl.OperatorImplGraph;
import org.apache.samza.system.EndOfStreamMessage;
import org.apache.samza.system.IncomingMessageEnvelope;
import org.apache.samza.system.MessageType;
import org.apache.samza.system.SystemStream;
import org.apache.samza.system.WatermarkMessage;
import org.apache.samza.task.ClosableTask;
import org.apache.samza.task.InitableTask;
import org.apache.samza.task.MessageCollector;
import org.apache.samza.task.StreamTask;
import org.apache.samza.task.TaskCoordinator;
import org.apache.samza.task.WindowableTask;
import org.apache.samza.util.Clock;
import org.apache.samza.util.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamOperatorTask
implements StreamTask,
InitableTask,
WindowableTask,
ClosableTask {
    private static final Logger LOG = LoggerFactory.getLogger(StreamOperatorTask.class);
    private final OperatorSpecGraph specGraph;
    private final Clock clock;
    private OperatorImplGraph operatorImplGraph;

    public StreamOperatorTask(OperatorSpecGraph specGraph, Clock clock) {
        this.specGraph = specGraph.clone();
        this.clock = clock;
    }

    public StreamOperatorTask(OperatorSpecGraph specGraph) {
        this(specGraph, SystemClock.instance());
    }

    public final void init(Context context) throws Exception {
        this.operatorImplGraph = new OperatorImplGraph(this.specGraph, context, this.clock);
    }

    public final void process(IncomingMessageEnvelope ime, MessageCollector collector, TaskCoordinator coordinator) {
        SystemStream systemStream = ime.getSystemStreamPartition().getSystemStream();
        InputOperatorImpl inputOpImpl = this.operatorImplGraph.getInputOperator(systemStream);
        if (inputOpImpl != null) {
            switch (MessageType.of((Object)ime.getMessage())) {
                case USER_MESSAGE: {
                    inputOpImpl.onMessage(ime, collector, coordinator);
                    break;
                }
                case END_OF_STREAM: {
                    EndOfStreamMessage eosMessage = (EndOfStreamMessage)ime.getMessage();
                    inputOpImpl.aggregateEndOfStream(eosMessage, ime.getSystemStreamPartition(), collector, coordinator);
                    break;
                }
                case WATERMARK: {
                    WatermarkMessage watermarkMessage = (WatermarkMessage)ime.getMessage();
                    inputOpImpl.aggregateWatermark(watermarkMessage, ime.getSystemStreamPartition(), collector, coordinator);
                }
            }
        }
    }

    public final void window(MessageCollector collector, TaskCoordinator coordinator) {
        this.operatorImplGraph.getAllInputOperators().forEach(inputOperator -> inputOperator.onTimer(collector, coordinator));
    }

    public void close() throws Exception {
        if (this.operatorImplGraph != null) {
            this.operatorImplGraph.close();
        }
    }

    OperatorImplGraph getOperatorImplGraph() {
        return this.operatorImplGraph;
    }
}

