/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.task;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.samza.scheduler.ScheduledCallback;

public class EpochTimeScheduler {
    private final ScheduledExecutorService executor;
    private final Map<Object, ScheduledFuture> scheduledFutures = new ConcurrentHashMap<Object, ScheduledFuture>();
    private final Map<TimerKey<?>, ScheduledCallback> readyTimers = new ConcurrentHashMap();
    private TimerListener timerListener;

    public static EpochTimeScheduler create(ScheduledExecutorService executor) {
        return new EpochTimeScheduler(executor);
    }

    private EpochTimeScheduler(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    public <K> void setTimer(K key, long timestamp, ScheduledCallback<K> callback) {
        Preconditions.checkState((!this.scheduledFutures.containsKey(key) ? 1 : 0) != 0, (Object)String.format("Duplicate key %s registration for the same timer", key));
        long delay = timestamp - System.currentTimeMillis();
        ScheduledFuture<?> scheduledFuture = this.executor.schedule(() -> {
            this.scheduledFutures.remove(key);
            this.readyTimers.put(TimerKey.of(key, timestamp), callback);
            if (this.timerListener != null) {
                this.timerListener.onTimer();
            }
        }, delay > 0L ? delay : 0L, TimeUnit.MILLISECONDS);
        this.scheduledFutures.put(key, scheduledFuture);
    }

    public <K> void deleteTimer(K key) {
        ScheduledFuture scheduledFuture = this.scheduledFutures.remove(key);
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
    }

    void registerListener(TimerListener listener) {
        this.timerListener = listener;
    }

    public Map<TimerKey<?>, ScheduledCallback> removeReadyTimers() {
        TreeMap timers = new TreeMap(this.readyTimers);
        this.readyTimers.keySet().removeAll(timers.keySet());
        return timers;
    }

    public static class TimerKey<K>
    implements Comparable<TimerKey<K>> {
        private final K key;
        private final long time;

        static <K> TimerKey<K> of(K key, long time) {
            return new TimerKey<K>(key, time);
        }

        private TimerKey(K key, long time) {
            this.key = key;
            this.time = time;
        }

        public K getKey() {
            return this.key;
        }

        public long getTime() {
            return this.time;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimerKey timerKey = (TimerKey)o;
            if (this.time != ((TimerKey)o).time) {
                return false;
            }
            return this.key.equals(timerKey.key);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + Long.valueOf(this.time).hashCode();
            return result;
        }

        public String toString() {
            return "TimerKey{key=" + this.key + ", time='" + this.time + '\'' + '}';
        }

        @Override
        public int compareTo(TimerKey<K> o) {
            int timeCompare = Long.compare(this.time, o.time);
            if (timeCompare != 0) {
                return timeCompare;
            }
            return this.key.hashCode() - o.key.hashCode();
        }
    }

    public static interface TimerListener {
        public void onTimer();
    }
}

