/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.task;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.samza.container.TaskName;
import org.apache.samza.task.ReadableCoordinator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorRequests {
    private static final Logger log = LoggerFactory.getLogger(CoordinatorRequests.class);
    private final Set<TaskName> taskNames;
    private final Set<TaskName> taskShutdownRequests = new CopyOnWriteArraySet<TaskName>();
    private final Set<TaskName> taskCommitRequests = new CopyOnWriteArraySet<TaskName>();
    private volatile boolean shutdownNow = false;

    public CoordinatorRequests(Set<TaskName> taskNames) {
        this.taskNames = taskNames;
    }

    public void update(ReadableCoordinator coordinator) {
        if (coordinator.commitRequest().isDefined() || coordinator.shutdownRequest().isDefined()) {
            this.checkCoordinator(coordinator);
        }
    }

    public Set<TaskName> commitRequests() {
        return this.taskCommitRequests;
    }

    public boolean shouldShutdownNow() {
        return this.shutdownNow;
    }

    private void checkCoordinator(ReadableCoordinator coordinator) {
        if (coordinator.requestedCommitTask()) {
            log.debug("Task {} requested commit for current task only", (Object)coordinator.taskName());
            this.taskCommitRequests.add(coordinator.taskName());
        }
        if (coordinator.requestedCommitAll()) {
            log.debug("Task {} requested commit for all tasks in the container", (Object)coordinator.taskName());
            this.taskCommitRequests.addAll(this.taskNames);
        }
        if (coordinator.requestedShutdownOnConsensus()) {
            this.taskShutdownRequests.add(coordinator.taskName());
            log.info("Shutdown has now been requested by tasks {}", this.taskShutdownRequests);
        }
        if (coordinator.requestedShutdownNow() || this.taskShutdownRequests.size() == this.taskNames.size()) {
            log.info("Shutdown requested.");
            this.shutdownNow = true;
        }
    }
}

