/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.task;

import java.util.concurrent.ExecutorService;
import org.apache.samza.context.Context;
import org.apache.samza.system.IncomingMessageEnvelope;
import org.apache.samza.task.AsyncStreamTask;
import org.apache.samza.task.ClosableTask;
import org.apache.samza.task.EndOfStreamListenerTask;
import org.apache.samza.task.InitableTask;
import org.apache.samza.task.MessageCollector;
import org.apache.samza.task.StreamTask;
import org.apache.samza.task.TaskCallback;
import org.apache.samza.task.TaskCoordinator;
import org.apache.samza.task.WindowableTask;

public class AsyncStreamTaskAdapter
implements AsyncStreamTask,
InitableTask,
WindowableTask,
ClosableTask,
EndOfStreamListenerTask {
    private final StreamTask wrappedTask;
    private final ExecutorService executor;

    public AsyncStreamTaskAdapter(StreamTask task, ExecutorService executor) {
        this.wrappedTask = task;
        this.executor = executor;
    }

    public void init(Context context) throws Exception {
        if (this.wrappedTask instanceof InitableTask) {
            ((InitableTask)this.wrappedTask).init(context);
        }
    }

    public void processAsync(final IncomingMessageEnvelope envelope, final MessageCollector collector, final TaskCoordinator coordinator, final TaskCallback callback) {
        if (this.executor != null) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    AsyncStreamTaskAdapter.this.process(envelope, collector, coordinator, callback);
                }
            });
        } else {
            this.process(envelope, collector, coordinator, callback);
        }
    }

    private void process(IncomingMessageEnvelope envelope, MessageCollector collector, TaskCoordinator coordinator, TaskCallback callback) {
        try {
            this.wrappedTask.process(envelope, collector, coordinator);
            callback.complete();
        }
        catch (Throwable t) {
            callback.failure(t);
        }
    }

    public void window(MessageCollector collector, TaskCoordinator coordinator) throws Exception {
        if (this.wrappedTask instanceof WindowableTask) {
            ((WindowableTask)this.wrappedTask).window(collector, coordinator);
        }
    }

    public void close() throws Exception {
        if (this.wrappedTask instanceof ClosableTask) {
            ((ClosableTask)this.wrappedTask).close();
        }
    }

    public void onEndOfStream(MessageCollector collector, TaskCoordinator coordinator) throws Exception {
        if (this.wrappedTask instanceof EndOfStreamListenerTask) {
            ((EndOfStreamListenerTask)this.wrappedTask).onEndOfStream(collector, coordinator);
        }
    }
}

