/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.task;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.samza.SamzaException;
import org.apache.samza.container.SamzaContainerMetrics;
import org.apache.samza.container.TaskInstance;
import org.apache.samza.container.TaskInstanceMetrics;
import org.apache.samza.container.TaskName;
import org.apache.samza.system.IncomingMessageEnvelope;
import org.apache.samza.system.SystemConsumers;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.task.CoordinatorRequests;
import org.apache.samza.task.EpochTimeScheduler;
import org.apache.samza.task.ReadableCoordinator;
import org.apache.samza.task.TaskCallback;
import org.apache.samza.task.TaskCallbackFactory;
import org.apache.samza.task.TaskCallbackImpl;
import org.apache.samza.task.TaskCallbackListener;
import org.apache.samza.task.TaskCallbackManager;
import org.apache.samza.task.TaskCoordinator;
import org.apache.samza.util.HighResolutionClock;
import org.apache.samza.util.Throttleable;
import org.apache.samza.util.ThrottlingScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConverters;

public class AsyncRunLoop
implements Runnable,
Throttleable {
    private static final Logger log = LoggerFactory.getLogger(AsyncRunLoop.class);
    private final List<AsyncTaskWorker> taskWorkers;
    private final SystemConsumers consumerMultiplexer;
    private final Map<SystemStreamPartition, List<AsyncTaskWorker>> sspToTaskWorkerMapping;
    private final ExecutorService threadPool;
    private final CoordinatorRequests coordinatorRequests;
    private final Object latch;
    private final int maxConcurrency;
    private final long windowMs;
    private final long commitMs;
    private final long callbackTimeoutMs;
    private final long maxIdleMs;
    private final SamzaContainerMetrics containerMetrics;
    private final ScheduledExecutorService workerTimer;
    private final ScheduledExecutorService callbackTimer;
    private final ThrottlingScheduler callbackExecutor;
    private volatile boolean shutdownNow = false;
    private volatile Throwable throwable = null;
    private final HighResolutionClock clock;
    private final boolean isAsyncCommitEnabled;
    private volatile boolean runLoopResumedSinceLastChecked;

    public AsyncRunLoop(Map<TaskName, TaskInstance> taskInstances, ExecutorService threadPool, SystemConsumers consumerMultiplexer, int maxConcurrency, long windowMs, long commitMs, long callbackTimeoutMs, long maxThrottlingDelayMs, long maxIdleMs, SamzaContainerMetrics containerMetrics, HighResolutionClock clock, boolean isAsyncCommitEnabled) {
        this.threadPool = threadPool;
        this.consumerMultiplexer = consumerMultiplexer;
        this.containerMetrics = containerMetrics;
        this.windowMs = windowMs;
        this.commitMs = commitMs;
        this.maxConcurrency = maxConcurrency;
        this.callbackTimeoutMs = callbackTimeoutMs;
        this.maxIdleMs = maxIdleMs;
        this.callbackTimer = callbackTimeoutMs > 0L ? Executors.newSingleThreadScheduledExecutor() : null;
        this.callbackExecutor = new ThrottlingScheduler(maxThrottlingDelayMs);
        this.coordinatorRequests = new CoordinatorRequests(taskInstances.keySet());
        this.latch = new Object();
        this.workerTimer = Executors.newSingleThreadScheduledExecutor();
        this.clock = clock;
        HashMap<TaskName, AsyncTaskWorker> workers = new HashMap<TaskName, AsyncTaskWorker>();
        for (TaskInstance task : taskInstances.values()) {
            workers.put(task.taskName(), new AsyncTaskWorker(task));
        }
        this.sspToTaskWorkerMapping = Collections.unmodifiableMap(AsyncRunLoop.getSspToAsyncTaskWorkerMap(taskInstances, workers));
        this.taskWorkers = Collections.unmodifiableList(new ArrayList(workers.values()));
        this.isAsyncCommitEnabled = isAsyncCommitEnabled;
    }

    private static Map<SystemStreamPartition, List<AsyncTaskWorker>> getSspToAsyncTaskWorkerMap(Map<TaskName, TaskInstance> taskInstances, Map<TaskName, AsyncTaskWorker> taskWorkers) {
        HashMap<SystemStreamPartition, List<AsyncTaskWorker>> sspToWorkerMap = new HashMap<SystemStreamPartition, List<AsyncTaskWorker>>();
        for (TaskInstance task : taskInstances.values()) {
            Set ssps = (Set)JavaConverters.setAsJavaSetConverter(task.systemStreamPartitions()).asJava();
            for (SystemStreamPartition ssp : ssps) {
                sspToWorkerMap.putIfAbsent(ssp, new ArrayList());
                ((List)sspToWorkerMap.get(ssp)).add(taskWorkers.get(task.taskName()));
            }
        }
        return sspToWorkerMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            for (AsyncTaskWorker taskWorker : this.taskWorkers) {
                taskWorker.init();
            }
            long prevNs = this.clock.nanoTime();
            while (!this.shutdownNow) {
                if (this.throwable != null) {
                    log.error("Caught throwable and stopping run loop", this.throwable);
                    throw new SamzaException(this.throwable);
                }
                long startNs = this.clock.nanoTime();
                IncomingMessageEnvelope envelope = this.chooseEnvelope();
                long chooseNs = this.clock.nanoTime();
                this.containerMetrics.chooseNs().update(chooseNs - startNs);
                this.blockIfBusyOrNoNewWork(envelope);
                long blockNs = this.clock.nanoTime();
                this.containerMetrics.blockNs().update(blockNs - chooseNs);
                this.runTasks(envelope);
                long currentNs = this.clock.nanoTime();
                long activeNs = currentNs - blockNs;
                long totalNs = currentNs - prevNs;
                prevNs = currentNs;
                if (totalNs == 0L) continue;
                this.containerMetrics.utilization().set((Object)((double)activeNs / (double)totalNs));
            }
        }
        finally {
            this.workerTimer.shutdown();
            this.callbackExecutor.shutdown();
            if (this.callbackTimer != null) {
                this.callbackTimer.shutdown();
            }
        }
    }

    @Override
    public void setWorkFactor(double workFactor) {
        this.callbackExecutor.setWorkFactor(workFactor);
    }

    @Override
    public double getWorkFactor() {
        return this.callbackExecutor.getWorkFactor();
    }

    public void shutdown() {
        this.shutdownNow = true;
    }

    private IncomingMessageEnvelope chooseEnvelope() {
        IncomingMessageEnvelope envelope = this.consumerMultiplexer.choose(false);
        if (envelope != null) {
            log.trace("Choose envelope ssp {} offset {} for processing", (Object)envelope.getSystemStreamPartition(), (Object)envelope.getOffset());
            this.containerMetrics.envelopes().inc();
        } else {
            log.trace("No envelope is available");
            this.containerMetrics.nullEnvelopes().inc();
        }
        return envelope;
    }

    private void runTasks(IncomingMessageEnvelope envelope) {
        if (envelope != null) {
            PendingEnvelope pendingEnvelope = new PendingEnvelope(envelope);
            for (AsyncTaskWorker worker : this.sspToTaskWorkerMapping.get(envelope.getSystemStreamPartition())) {
                worker.state.insertEnvelope(pendingEnvelope);
            }
        }
        for (AsyncTaskWorker worker : this.taskWorkers) {
            worker.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockIfBusyOrNoNewWork(IncomingMessageEnvelope envelope) {
        Object object = this.latch;
        synchronized (object) {
            if (envelope == null && !this.runLoopResumedSinceLastChecked) {
                try {
                    log.trace("Start no work wait");
                    this.latch.wait(this.maxIdleMs);
                    log.trace("End no work wait");
                }
                catch (InterruptedException e) {
                    throw new SamzaException("Run loop is interrupted", (Throwable)e);
                }
            }
            this.runLoopResumedSinceLastChecked = false;
            while (!this.shutdownNow && this.throwable == null) {
                for (AsyncTaskWorker worker : this.taskWorkers) {
                    if (!worker.state.isReady()) continue;
                    return;
                }
                try {
                    log.trace("Block loop thread");
                    this.latch.wait();
                }
                catch (InterruptedException e) {
                    throw new SamzaException("Run loop is interrupted", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resume() {
        log.trace("Resume loop thread");
        if (this.coordinatorRequests.shouldShutdownNow() && this.coordinatorRequests.commitRequests().isEmpty()) {
            this.shutdownNow = true;
        }
        Object object = this.latch;
        synchronized (object) {
            this.latch.notifyAll();
            this.runLoopResumedSinceLastChecked = true;
        }
    }

    private void abort(Throwable t) {
        this.throwable = t;
    }

    private final class AsyncTaskState {
        private volatile boolean needWindow = false;
        private volatile boolean needCommit = false;
        private volatile boolean needScheduler = false;
        private volatile boolean complete = false;
        private volatile boolean endOfStream = false;
        private volatile boolean windowInFlight = false;
        private volatile boolean commitInFlight = false;
        private volatile boolean schedulerInFlight = false;
        private final AtomicInteger messagesInFlight = new AtomicInteger(0);
        private final ArrayDeque<PendingEnvelope> pendingEnvelopeQueue;
        private final Set<SystemStreamPartition> processingSspSet;
        private final TaskName taskName;
        private final TaskInstanceMetrics taskMetrics;
        private final boolean hasIntermediateStreams;

        AsyncTaskState(TaskName taskName, TaskInstanceMetrics taskMetrics, Set<SystemStreamPartition> sspSet, boolean hasIntermediateStreams) {
            this.taskName = taskName;
            this.taskMetrics = taskMetrics;
            this.pendingEnvelopeQueue = new ArrayDeque();
            this.processingSspSet = sspSet;
            this.hasIntermediateStreams = hasIntermediateStreams;
        }

        private boolean checkEndOfStream() {
            PendingEnvelope pendingEnvelope;
            IncomingMessageEnvelope envelope;
            if (this.pendingEnvelopeQueue.size() == 1 && (envelope = (pendingEnvelope = this.pendingEnvelopeQueue.peek()).envelope).isEndOfStream()) {
                SystemStreamPartition ssp = envelope.getSystemStreamPartition();
                this.processingSspSet.remove(ssp);
                if (!this.hasIntermediateStreams) {
                    this.pendingEnvelopeQueue.remove();
                }
            }
            return this.processingSspSet.isEmpty();
        }

        private boolean isReady() {
            boolean opInFlight;
            if (this.checkEndOfStream()) {
                this.endOfStream = true;
            }
            if (AsyncRunLoop.this.coordinatorRequests.commitRequests().remove(this.taskName)) {
                this.needCommit = true;
            }
            boolean bl = opInFlight = this.windowInFlight || this.commitInFlight || this.schedulerInFlight;
            if (this.needCommit) {
                return (this.messagesInFlight.get() == 0 || AsyncRunLoop.this.isAsyncCommitEnabled) && !opInFlight;
            }
            if (this.needWindow || this.needScheduler || this.endOfStream) {
                return this.messagesInFlight.get() == 0 && !opInFlight;
            }
            return this.messagesInFlight.get() < AsyncRunLoop.this.maxConcurrency && !this.windowInFlight && !this.schedulerInFlight && (AsyncRunLoop.this.isAsyncCommitEnabled || !this.commitInFlight);
        }

        private WorkerOp nextOp() {
            if (this.complete) {
                return WorkerOp.NO_OP;
            }
            if (this.isReady()) {
                if (this.needCommit) {
                    return WorkerOp.COMMIT;
                }
                if (this.needWindow) {
                    return WorkerOp.WINDOW;
                }
                if (this.needScheduler) {
                    return WorkerOp.SCHEDULER;
                }
                if (this.endOfStream && this.pendingEnvelopeQueue.isEmpty()) {
                    return WorkerOp.END_OF_STREAM;
                }
                if (!this.pendingEnvelopeQueue.isEmpty()) {
                    return WorkerOp.PROCESS;
                }
            }
            return WorkerOp.NO_OP;
        }

        private void needWindow() {
            this.needWindow = true;
        }

        private void needCommit() {
            this.needCommit = true;
        }

        private void needScheduler() {
            this.needScheduler = true;
        }

        private void startWindow() {
            this.needWindow = false;
            this.windowInFlight = true;
        }

        private void startCommit() {
            this.needCommit = false;
            this.commitInFlight = true;
        }

        private void startProcess() {
            int count = this.messagesInFlight.incrementAndGet();
            this.taskMetrics.messagesInFlight().set((Object)count);
        }

        private void startScheduler() {
            this.needScheduler = false;
            this.schedulerInFlight = true;
        }

        private void doneCommit() {
            this.commitInFlight = false;
        }

        private void doneWindow() {
            this.windowInFlight = false;
        }

        private void doneProcess() {
            int count = this.messagesInFlight.decrementAndGet();
            this.taskMetrics.messagesInFlight().set((Object)count);
        }

        private void doneScheduler() {
            this.schedulerInFlight = false;
        }

        private void insertEnvelope(PendingEnvelope pendingEnvelope) {
            this.pendingEnvelopeQueue.add(pendingEnvelope);
            int queueSize = this.pendingEnvelopeQueue.size();
            this.taskMetrics.pendingMessages().set((Object)queueSize);
            log.trace("Insert envelope to task {} queue.", (Object)this.taskName);
            log.debug("Task {} pending envelope count is {} after insertion.", (Object)this.taskName, (Object)queueSize);
        }

        private IncomingMessageEnvelope fetchEnvelope() {
            PendingEnvelope pendingEnvelope = this.pendingEnvelopeQueue.remove();
            int queueSize = this.pendingEnvelopeQueue.size();
            this.taskMetrics.pendingMessages().set((Object)queueSize);
            log.trace("fetch envelope ssp {} offset {} to process.", (Object)pendingEnvelope.envelope.getSystemStreamPartition(), (Object)pendingEnvelope.envelope.getOffset());
            log.debug("Task {} pending envelopes count is {} after fetching.", (Object)this.taskName, (Object)queueSize);
            if (pendingEnvelope.markProcessed()) {
                SystemStreamPartition partition = pendingEnvelope.envelope.getSystemStreamPartition();
                AsyncRunLoop.this.consumerMultiplexer.tryUpdate(partition);
                log.debug("Update chooser for {}", (Object)partition);
            }
            return pendingEnvelope.envelope;
        }
    }

    private class AsyncTaskWorker
    implements TaskCallbackListener {
        private final TaskInstance task;
        private final TaskCallbackManager callbackManager;
        private volatile AsyncTaskState state;

        AsyncTaskWorker(TaskInstance task) {
            this.task = task;
            this.callbackManager = new TaskCallbackManager(this, AsyncRunLoop.this.callbackTimer, AsyncRunLoop.this.callbackTimeoutMs, AsyncRunLoop.this.maxConcurrency, AsyncRunLoop.this.clock);
            Set<SystemStreamPartition> sspSet = this.getWorkingSSPSet(task);
            this.state = new AsyncTaskState(task.taskName(), task.metrics(), sspSet, task.intermediateStreams().nonEmpty());
        }

        private void init() {
            EpochTimeScheduler epochTimeScheduler;
            if (this.task.isWindowableTask() && AsyncRunLoop.this.windowMs > 0L) {
                AsyncRunLoop.this.workerTimer.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        log.trace("Task {} need window", (Object)AsyncTaskWorker.this.task.taskName());
                        AsyncTaskWorker.this.state.needWindow();
                        AsyncRunLoop.this.resume();
                    }
                }, AsyncRunLoop.this.windowMs, AsyncRunLoop.this.windowMs, TimeUnit.MILLISECONDS);
            }
            if (AsyncRunLoop.this.commitMs > 0L) {
                AsyncRunLoop.this.workerTimer.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        log.trace("Task {} need commit", (Object)AsyncTaskWorker.this.task.taskName());
                        AsyncTaskWorker.this.state.needCommit();
                        AsyncRunLoop.this.resume();
                    }
                }, AsyncRunLoop.this.commitMs, AsyncRunLoop.this.commitMs, TimeUnit.MILLISECONDS);
            }
            if ((epochTimeScheduler = this.task.epochTimeScheduler()) != null) {
                epochTimeScheduler.registerListener(() -> this.state.needScheduler());
            }
        }

        private Set<SystemStreamPartition> getWorkingSSPSet(TaskInstance task) {
            HashSet allPartitions = new HashSet((Collection)JavaConverters.setAsJavaSetConverter(task.systemStreamPartitions()).asJava());
            Set<SystemStreamPartition> workingSSPSet = allPartitions.stream().filter(ssp -> !AsyncRunLoop.this.consumerMultiplexer.isEndOfStream((SystemStreamPartition)ssp)).collect(Collectors.toSet());
            return workingSSPSet;
        }

        private void run() {
            switch (this.state.nextOp()) {
                case PROCESS: {
                    this.process();
                    break;
                }
                case WINDOW: {
                    this.window();
                    break;
                }
                case SCHEDULER: {
                    this.scheduler();
                    break;
                }
                case COMMIT: {
                    this.commit();
                    break;
                }
                case END_OF_STREAM: {
                    this.endOfStream();
                    break;
                }
            }
        }

        private void endOfStream() {
            this.state.complete = true;
            try {
                ReadableCoordinator coordinator = new ReadableCoordinator(this.task.taskName());
                this.task.endOfStream(coordinator);
                coordinator.shutdown(TaskCoordinator.RequestScope.CURRENT_TASK);
                AsyncRunLoop.this.coordinatorRequests.update(coordinator);
                boolean needFinalCommit = AsyncRunLoop.this.coordinatorRequests.commitRequests().remove(this.task.taskName());
                if (needFinalCommit) {
                    this.task.commit();
                }
            }
            finally {
                AsyncRunLoop.this.resume();
            }
        }

        private void process() {
            final IncomingMessageEnvelope envelope = this.state.fetchEnvelope();
            log.trace("Process ssp {} offset {}", (Object)envelope.getSystemStreamPartition(), (Object)envelope.getOffset());
            final ReadableCoordinator coordinator = new ReadableCoordinator(this.task.taskName());
            TaskCallbackFactory callbackFactory = new TaskCallbackFactory(){

                @Override
                public TaskCallback createCallback() {
                    AsyncTaskWorker.this.state.startProcess();
                    AsyncRunLoop.this.containerMetrics.processes().inc();
                    return AsyncTaskWorker.this.callbackManager.createCallback(AsyncTaskWorker.this.task.taskName(), envelope, coordinator);
                }
            };
            this.task.process(envelope, coordinator, callbackFactory);
        }

        private void window() {
            this.state.startWindow();
            Runnable windowWorker = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        AsyncRunLoop.this.containerMetrics.windows().inc();
                        ReadableCoordinator coordinator = new ReadableCoordinator(AsyncTaskWorker.this.task.taskName());
                        long startTime = AsyncRunLoop.this.clock.nanoTime();
                        AsyncTaskWorker.this.task.window(coordinator);
                        AsyncRunLoop.this.containerMetrics.windowNs().update(AsyncRunLoop.this.clock.nanoTime() - startTime);
                        long averageWindowMs = TimeUnit.NANOSECONDS.toMillis((long)AsyncRunLoop.this.containerMetrics.windowNs().getSnapshot().getAverage());
                        if (averageWindowMs >= AsyncRunLoop.this.windowMs) {
                            log.warn("Average window call duration {} is greater than the configured task.window.ms {}. This can starve process calls, so consider setting task.window.ms >> {} ms.", new Object[]{averageWindowMs, AsyncRunLoop.this.windowMs, averageWindowMs});
                        }
                        AsyncRunLoop.this.coordinatorRequests.update(coordinator);
                        AsyncTaskWorker.this.state.doneWindow();
                    }
                    catch (Throwable t) {
                        log.error("Task {} window failed", (Object)AsyncTaskWorker.this.task.taskName(), (Object)t);
                        AsyncRunLoop.this.abort(t);
                    }
                    finally {
                        log.trace("Task {} window completed", (Object)AsyncTaskWorker.this.task.taskName());
                        AsyncRunLoop.this.resume();
                    }
                }
            };
            if (AsyncRunLoop.this.threadPool != null) {
                log.trace("Task {} window on the thread pool", (Object)this.task.taskName());
                AsyncRunLoop.this.threadPool.submit(windowWorker);
            } else {
                log.trace("Task {} window on the run loop thread", (Object)this.task.taskName());
                windowWorker.run();
            }
        }

        private void commit() {
            this.state.startCommit();
            Runnable commitWorker = new Runnable(){

                @Override
                public void run() {
                    try {
                        AsyncRunLoop.this.containerMetrics.commits().inc();
                        long startTime = AsyncRunLoop.this.clock.nanoTime();
                        AsyncTaskWorker.this.task.commit();
                        AsyncRunLoop.this.containerMetrics.commitNs().update(AsyncRunLoop.this.clock.nanoTime() - startTime);
                        AsyncTaskWorker.this.state.doneCommit();
                    }
                    catch (Throwable t) {
                        log.error("Task {} commit failed", (Object)AsyncTaskWorker.this.task.taskName(), (Object)t);
                        AsyncRunLoop.this.abort(t);
                    }
                    finally {
                        log.trace("Task {} commit completed", (Object)AsyncTaskWorker.this.task.taskName());
                        AsyncRunLoop.this.resume();
                    }
                }
            };
            if (AsyncRunLoop.this.threadPool != null) {
                log.trace("Task {} commits on the thread pool", (Object)this.task.taskName());
                AsyncRunLoop.this.threadPool.submit(commitWorker);
            } else {
                log.trace("Task {} commits on the run loop thread", (Object)this.task.taskName());
                commitWorker.run();
            }
        }

        private void scheduler() {
            this.state.startScheduler();
            Runnable timerWorker = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ReadableCoordinator coordinator = new ReadableCoordinator(AsyncTaskWorker.this.task.taskName());
                        long startTime = AsyncRunLoop.this.clock.nanoTime();
                        AsyncTaskWorker.this.task.scheduler(coordinator);
                        AsyncRunLoop.this.containerMetrics.timerNs().update(AsyncRunLoop.this.clock.nanoTime() - startTime);
                        AsyncRunLoop.this.coordinatorRequests.update(coordinator);
                        AsyncTaskWorker.this.state.doneScheduler();
                    }
                    catch (Throwable t) {
                        log.error("Task {} scheduler failed", (Object)AsyncTaskWorker.this.task.taskName(), (Object)t);
                        AsyncRunLoop.this.abort(t);
                    }
                    finally {
                        log.trace("Task {} scheduler completed", (Object)AsyncTaskWorker.this.task.taskName());
                        AsyncRunLoop.this.resume();
                    }
                }
            };
            if (AsyncRunLoop.this.threadPool != null) {
                log.trace("Task {} scheduler runs on the thread pool", (Object)this.task.taskName());
                AsyncRunLoop.this.threadPool.submit(timerWorker);
            } else {
                log.trace("Task {} scheduler runs on the run loop thread", (Object)this.task.taskName());
                timerWorker.run();
            }
        }

        @Override
        public void onComplete(final TaskCallback callback) {
            long workNanos = AsyncRunLoop.this.clock.nanoTime() - ((TaskCallbackImpl)callback).timeCreatedNs;
            AsyncRunLoop.this.callbackExecutor.schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        AsyncTaskWorker.this.state.doneProcess();
                        AsyncTaskWorker.this.state.taskMetrics.asyncCallbackCompleted().inc();
                        TaskCallbackImpl callbackImpl = (TaskCallbackImpl)callback;
                        AsyncRunLoop.this.containerMetrics.processNs().update(AsyncRunLoop.this.clock.nanoTime() - callbackImpl.timeCreatedNs);
                        log.trace("Got callback complete for task {}, ssp {}", (Object)callbackImpl.taskName, (Object)callbackImpl.envelope.getSystemStreamPartition());
                        List<TaskCallbackImpl> callbacksToUpdate = AsyncTaskWorker.this.callbackManager.updateCallback(callbackImpl);
                        for (TaskCallbackImpl callbackToUpdate : callbacksToUpdate) {
                            IncomingMessageEnvelope envelope = callbackToUpdate.envelope;
                            log.trace("Update offset for ssp {}, offset {}", (Object)envelope.getSystemStreamPartition(), (Object)envelope.getOffset());
                            AsyncTaskWorker.this.task.offsetManager().update(AsyncTaskWorker.this.task.taskName(), envelope.getSystemStreamPartition(), envelope.getOffset());
                            AsyncRunLoop.this.coordinatorRequests.update(callbackToUpdate.coordinator);
                        }
                    }
                    catch (Throwable t) {
                        log.error("Error marking process as complete.", t);
                        AsyncRunLoop.this.abort(t);
                    }
                    finally {
                        AsyncRunLoop.this.resume();
                    }
                }
            }, workNanos);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(TaskCallback callback, Throwable t) {
            try {
                this.state.doneProcess();
                AsyncRunLoop.this.abort(t);
                TaskCallbackImpl callbackImpl = (TaskCallbackImpl)callback;
                log.error("Got callback failure for task {}", (Object)callbackImpl.taskName, (Object)t);
            }
            catch (Throwable e) {
                log.error("Error marking process as failed.", e);
            }
            finally {
                AsyncRunLoop.this.resume();
            }
        }
    }

    private static enum WorkerOp {
        WINDOW,
        COMMIT,
        PROCESS,
        END_OF_STREAM,
        SCHEDULER,
        NO_OP;

    }

    private static final class PendingEnvelope {
        private final IncomingMessageEnvelope envelope;
        private boolean processed = false;

        PendingEnvelope(IncomingMessageEnvelope envelope) {
            this.envelope = envelope;
        }

        private boolean markProcessed() {
            boolean oldValue = this.processed;
            this.processed = true;
            return !oldValue;
        }
    }
}

