/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.utils.descriptors;

import java.util.HashMap;
import java.util.Map;
import org.apache.samza.config.Config;
import org.apache.samza.context.Context;
import org.apache.samza.table.TableSpec;
import org.apache.samza.table.descriptors.TableProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTableProvider
implements TableProvider {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final TableSpec tableSpec;
    protected Context context;

    public BaseTableProvider(TableSpec tableSpec) {
        this.tableSpec = tableSpec;
    }

    public void init(Context context) {
        this.context = context;
    }

    public Map<String, String> generateConfig(Config jobConfig, Map<String, String> generatedConfig) {
        HashMap<String, String> tableConfig = new HashMap<String, String>();
        this.tableSpec.getConfig().forEach((k, v) -> {
            String realKey = String.format("tables.%s", this.tableSpec.getId()) + "." + k;
            tableConfig.put(realKey, (String)v);
        });
        this.logger.info("Generated configuration for table " + this.tableSpec.getId());
        return tableConfig;
    }
}

