/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.utils;

import com.google.common.base.Preconditions;
import java.util.function.Supplier;
import org.apache.samza.context.Context;
import org.apache.samza.metrics.Counter;
import org.apache.samza.metrics.Gauge;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.metrics.Timer;
import org.apache.samza.table.Table;
import org.apache.samza.table.caching.SupplierGauge;

public class TableMetricsUtil {
    private final MetricsRegistry metricsRegistry;
    private final String groupName;
    private final String tableId;

    public TableMetricsUtil(Context context, Table table, String tableId) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)table);
        Preconditions.checkNotNull((Object)tableId);
        this.metricsRegistry = context.getTaskContext().getTaskMetricsRegistry();
        this.groupName = table.getClass().getSimpleName();
        this.tableId = tableId;
    }

    public Counter newCounter(String name) {
        return this.metricsRegistry.newCounter(this.groupName, this.getMetricFullName(name));
    }

    public Timer newTimer(String name) {
        return this.metricsRegistry.newTimer(this.groupName, this.getMetricFullName(name));
    }

    public <T> Gauge<T> newGauge(String name, Supplier<T> supplier) {
        return this.metricsRegistry.newGauge(this.groupName, new SupplierGauge<T>(this.getMetricFullName(name), supplier));
    }

    private String getMetricFullName(String name) {
        return String.format("%s-%s", this.tableId, name);
    }
}

