/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.utils;

import org.apache.samza.context.Context;
import org.apache.samza.metrics.Counter;
import org.apache.samza.metrics.Timer;
import org.apache.samza.table.Table;
import org.apache.samza.table.utils.TableMetricsUtil;

public class DefaultTableWriteMetrics {
    public final Timer putNs;
    public final Timer putAllNs;
    public final Timer deleteNs;
    public final Timer deleteAllNs;
    public final Timer flushNs;
    public final Counter numPuts;
    public final Counter numPutAlls;
    public final Counter numDeletes;
    public final Counter numDeleteAlls;
    public final Counter numFlushes;
    public final Timer putCallbackNs;
    public final Timer deleteCallbackNs;

    public DefaultTableWriteMetrics(Context context, Table table, String tableId) {
        TableMetricsUtil tableMetricsUtil = new TableMetricsUtil(context, table, tableId);
        this.putNs = tableMetricsUtil.newTimer("put-ns");
        this.putAllNs = tableMetricsUtil.newTimer("putAll-ns");
        this.deleteNs = tableMetricsUtil.newTimer("delete-ns");
        this.deleteAllNs = tableMetricsUtil.newTimer("deleteAll-ns");
        this.flushNs = tableMetricsUtil.newTimer("flush-ns");
        this.numPuts = tableMetricsUtil.newCounter("num-puts");
        this.numPutAlls = tableMetricsUtil.newCounter("num-putAlls");
        this.numDeletes = tableMetricsUtil.newCounter("num-deletes");
        this.numDeleteAlls = tableMetricsUtil.newCounter("num-deleteAlls");
        this.numFlushes = tableMetricsUtil.newCounter("num-flushes");
        this.putCallbackNs = tableMetricsUtil.newTimer("put-callback-ns");
        this.deleteCallbackNs = tableMetricsUtil.newTimer("delete-callback-ns");
    }
}

