/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.retry;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import net.jodah.failsafe.RetryPolicy;
import org.apache.samza.SamzaException;
import org.apache.samza.storage.kv.Entry;
import org.apache.samza.table.remote.TableWriteFunction;
import org.apache.samza.table.retry.FailsafeAdapter;
import org.apache.samza.table.retry.RetryMetrics;
import org.apache.samza.table.retry.TableRetryPolicy;
import org.apache.samza.table.utils.TableMetricsUtil;

public class RetriableWriteFunction<K, V>
implements TableWriteFunction<K, V> {
    private final RetryPolicy retryPolicy;
    private final TableWriteFunction<K, V> writeFn;
    private final ScheduledExecutorService retryExecutor;
    @VisibleForTesting
    RetryMetrics retryMetrics;

    public RetriableWriteFunction(TableRetryPolicy policy, TableWriteFunction<K, V> writeFn, ScheduledExecutorService retryExecutor) {
        Preconditions.checkNotNull((Object)policy);
        Preconditions.checkNotNull(writeFn);
        Preconditions.checkNotNull((Object)retryExecutor);
        this.writeFn = writeFn;
        this.retryExecutor = retryExecutor;
        TableRetryPolicy.RetryPredicate retryPredicate = policy.getRetryPredicate();
        policy.withRetryPredicate(ex -> writeFn.isRetriable((Throwable)ex) || retryPredicate.test(ex));
        this.retryPolicy = FailsafeAdapter.valueOf(policy);
    }

    @Override
    public CompletableFuture<Void> putAsync(K key, V record) {
        return FailsafeAdapter.failsafe(this.retryPolicy, this.retryMetrics, this.retryExecutor).future(() -> this.writeFn.putAsync(key, record)).exceptionally(e -> {
            throw new SamzaException("Failed to get the record for " + key + " after retries.", e);
        });
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Collection<Entry<K, V>> records) {
        return FailsafeAdapter.failsafe(this.retryPolicy, this.retryMetrics, this.retryExecutor).future(() -> this.writeFn.putAllAsync(records)).exceptionally(e -> {
            throw new SamzaException("Failed to put records after retries.", e);
        });
    }

    @Override
    public CompletableFuture<Void> deleteAsync(K key) {
        return FailsafeAdapter.failsafe(this.retryPolicy, this.retryMetrics, this.retryExecutor).future(() -> this.writeFn.deleteAsync(key)).exceptionally(e -> {
            throw new SamzaException("Failed to delete the record for " + key + " after retries.", e);
        });
    }

    @Override
    public CompletableFuture<Void> deleteAllAsync(Collection<K> keys) {
        return FailsafeAdapter.failsafe(this.retryPolicy, this.retryMetrics, this.retryExecutor).future(() -> this.writeFn.deleteAllAsync(keys)).exceptionally(e -> {
            throw new SamzaException("Failed to delete the records for " + keys + " after retries.", e);
        });
    }

    @Override
    public boolean isRetriable(Throwable exception) {
        return this.writeFn.isRetriable(exception);
    }

    public void setMetrics(TableMetricsUtil metricsUtil) {
        this.retryMetrics = new RetryMetrics("writer", metricsUtil);
    }
}

