/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.retry;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import net.jodah.failsafe.RetryPolicy;
import org.apache.samza.SamzaException;
import org.apache.samza.table.remote.TableReadFunction;
import org.apache.samza.table.retry.FailsafeAdapter;
import org.apache.samza.table.retry.RetryMetrics;
import org.apache.samza.table.retry.TableRetryPolicy;
import org.apache.samza.table.utils.TableMetricsUtil;

public class RetriableReadFunction<K, V>
implements TableReadFunction<K, V> {
    private final RetryPolicy retryPolicy;
    private final TableReadFunction<K, V> readFn;
    private final ScheduledExecutorService retryExecutor;
    @VisibleForTesting
    RetryMetrics retryMetrics;

    public RetriableReadFunction(TableRetryPolicy policy, TableReadFunction<K, V> readFn, ScheduledExecutorService retryExecutor) {
        Preconditions.checkNotNull((Object)policy);
        Preconditions.checkNotNull(readFn);
        Preconditions.checkNotNull((Object)retryExecutor);
        this.readFn = readFn;
        this.retryExecutor = retryExecutor;
        TableRetryPolicy.RetryPredicate retryPredicate = policy.getRetryPredicate();
        policy.withRetryPredicate(ex -> readFn.isRetriable((Throwable)ex) || retryPredicate.test(ex));
        this.retryPolicy = FailsafeAdapter.valueOf(policy);
    }

    @Override
    public CompletableFuture<V> getAsync(K key) {
        return FailsafeAdapter.failsafe(this.retryPolicy, this.retryMetrics, this.retryExecutor).future(() -> this.readFn.getAsync(key)).exceptionally(e -> {
            throw new SamzaException("Failed to get the record for " + key + " after retries.", e);
        });
    }

    @Override
    public CompletableFuture<Map<K, V>> getAllAsync(Collection<K> keys) {
        return FailsafeAdapter.failsafe(this.retryPolicy, this.retryMetrics, this.retryExecutor).future(() -> this.readFn.getAllAsync(keys)).exceptionally(e -> {
            throw new SamzaException("Failed to get the records for " + keys + " after retries.", e);
        });
    }

    @Override
    public boolean isRetriable(Throwable exception) {
        return this.readFn.isRetriable(exception);
    }

    public void setMetrics(TableMetricsUtil metricsUtil) {
        this.retryMetrics = new RetryMetrics("reader", metricsUtil);
    }
}

