/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.retry;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.AsyncFailsafe;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.RetryPolicy;
import org.apache.samza.SamzaException;
import org.apache.samza.table.retry.RetryMetrics;
import org.apache.samza.table.retry.TableRetryPolicy;

class FailsafeAdapter {
    FailsafeAdapter() {
    }

    static RetryPolicy valueOf(TableRetryPolicy policy) {
        RetryPolicy failSafePolicy = new RetryPolicy();
        switch (policy.getBackoffType()) {
            case NONE: {
                break;
            }
            case FIXED: {
                failSafePolicy.withDelay(policy.getSleepTime().toMillis(), TimeUnit.MILLISECONDS);
                break;
            }
            case RANDOM: {
                failSafePolicy.withDelay(policy.getRandomMin().toMillis(), policy.getRandomMax().toMillis(), TimeUnit.MILLISECONDS);
                break;
            }
            case EXPONENTIAL: {
                failSafePolicy.withBackoff(policy.getSleepTime().toMillis(), policy.getExponentialMaxSleep().toMillis(), TimeUnit.MILLISECONDS, policy.getExponentialFactor());
                break;
            }
            default: {
                throw new SamzaException("Unknown retry policy type.");
            }
        }
        if (policy.getMaxDuration() != null) {
            failSafePolicy.withMaxDuration(policy.getMaxDuration().toMillis(), TimeUnit.MILLISECONDS);
        }
        if (policy.getMaxAttempts() != null) {
            failSafePolicy.withMaxRetries(policy.getMaxAttempts().intValue());
        }
        if (policy.getJitter() != null && policy.getBackoffType() != TableRetryPolicy.BackoffType.RANDOM) {
            failSafePolicy.withJitter(policy.getJitter().toMillis(), TimeUnit.MILLISECONDS);
        }
        failSafePolicy.retryOn(e -> policy.getRetryPredicate().test(e));
        return failSafePolicy;
    }

    static AsyncFailsafe<?> failsafe(RetryPolicy retryPolicy, RetryMetrics metrics, ScheduledExecutorService retryExec) {
        long startMs = System.currentTimeMillis();
        return (AsyncFailsafe)((AsyncFailsafe)((AsyncFailsafe)Failsafe.with((RetryPolicy)retryPolicy).with(retryExec).onRetry(e -> metrics.retryCount.inc())).onRetriesExceeded(e -> {
            metrics.retryTimer.update(System.currentTimeMillis() - startMs);
            metrics.permFailureCount.inc();
        })).onSuccess((e, ctx) -> {
            if (ctx.getExecutions() > 1) {
                metrics.retryTimer.update(System.currentTimeMillis() - startMs);
            } else {
                metrics.successCount.inc();
            }
        });
    }
}

