/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.remote.descriptors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.samza.table.Table;
import org.apache.samza.table.TableSpec;
import org.apache.samza.table.remote.RemoteReadWriteTable;
import org.apache.samza.table.remote.RemoteReadableTable;
import org.apache.samza.table.remote.TableRateLimiter;
import org.apache.samza.table.remote.TableReadFunction;
import org.apache.samza.table.remote.TableWriteFunction;
import org.apache.samza.table.retry.RetriableReadFunction;
import org.apache.samza.table.retry.RetriableWriteFunction;
import org.apache.samza.table.retry.TableRetryPolicy;
import org.apache.samza.table.utils.SerdeUtils;
import org.apache.samza.table.utils.TableMetricsUtil;
import org.apache.samza.table.utils.descriptors.BaseTableProvider;
import org.apache.samza.util.RateLimiter;

public class RemoteTableProvider
extends BaseTableProvider {
    static final String READ_FN = "io.read.func";
    static final String WRITE_FN = "io.write.func";
    static final String RATE_LIMITER = "io.ratelimiter";
    static final String READ_CREDIT_FN = "io.read.credit.func";
    static final String WRITE_CREDIT_FN = "io.write.credit.func";
    static final String ASYNC_CALLBACK_POOL_SIZE = "io.async.callback.pool.size";
    static final String READ_RETRY_POLICY = "io.read.retry.policy";
    static final String WRITE_RETRY_POLICY = "io.write.retry.policy";
    private final boolean readOnly;
    private final List<RemoteReadableTable<?, ?>> tables = new ArrayList();
    private static Map<String, ExecutorService> tableExecutors = new ConcurrentHashMap<String, ExecutorService>();
    private static Map<String, ExecutorService> callbackExecutors = new ConcurrentHashMap<String, ExecutorService>();
    private static ScheduledExecutorService retryExecutor;

    public RemoteTableProvider(TableSpec tableSpec) {
        super(tableSpec);
        this.readOnly = !tableSpec.getConfig().containsKey(WRITE_FN);
    }

    public Table getTable() {
        int callbackPoolSize;
        String tableId = this.tableSpec.getId();
        TableReadFunction<?, ?> readFn = this.getReadFn();
        RateLimiter rateLimiter = (RateLimiter)this.deserializeObject(RATE_LIMITER);
        if (rateLimiter != null) {
            rateLimiter.init(this.context);
        }
        TableRateLimiter.CreditFunction readCreditFn = (TableRateLimiter.CreditFunction)this.deserializeObject(READ_CREDIT_FN);
        TableRateLimiter readRateLimiter = new TableRateLimiter(this.tableSpec.getId(), rateLimiter, readCreditFn, "readTag");
        TableRateLimiter writeRateLimiter = null;
        TableRetryPolicy readRetryPolicy = (TableRetryPolicy)this.deserializeObject(READ_RETRY_POLICY);
        TableRetryPolicy writeRetryPolicy = null;
        if ((readRetryPolicy != null || writeRetryPolicy != null) && retryExecutor == null) {
            retryExecutor = Executors.newSingleThreadScheduledExecutor(runnable -> {
                Thread thread = new Thread(runnable);
                thread.setName("table-retry-executor");
                thread.setDaemon(true);
                return thread;
            });
        }
        if (readRetryPolicy != null) {
            readFn = new RetriableReadFunction(readRetryPolicy, readFn, retryExecutor);
        }
        TableWriteFunction<?, ?> writeFn = this.getWriteFn();
        boolean isRateLimited = readRateLimiter.isRateLimited();
        if (!this.readOnly) {
            TableRateLimiter.CreditFunction writeCreditFn = (TableRateLimiter.CreditFunction)this.deserializeObject(WRITE_CREDIT_FN);
            writeRateLimiter = new TableRateLimiter(this.tableSpec.getId(), rateLimiter, writeCreditFn, "writeTag");
            isRateLimited |= writeRateLimiter.isRateLimited();
            writeRetryPolicy = (TableRetryPolicy)this.deserializeObject(WRITE_RETRY_POLICY);
            if (writeRetryPolicy != null) {
                writeFn = new RetriableWriteFunction(writeRetryPolicy, writeFn, retryExecutor);
            }
        }
        if ((callbackPoolSize = Integer.parseInt((String)this.tableSpec.getConfig().get(ASYNC_CALLBACK_POOL_SIZE))) > 0) {
            callbackExecutors.computeIfAbsent(tableId, arg -> Executors.newFixedThreadPool(callbackPoolSize, runnable -> {
                Thread thread = new Thread(runnable);
                thread.setName("table-" + tableId + "-async-callback-pool");
                thread.setDaemon(true);
                return thread;
            }));
        }
        if (isRateLimited) {
            tableExecutors.computeIfAbsent(tableId, arg -> Executors.newSingleThreadExecutor(runnable -> {
                Thread thread = new Thread(runnable);
                thread.setName("table-" + tableId + "-async-executor");
                thread.setDaemon(true);
                return thread;
            }));
        }
        RemoteReadableTable table = this.readOnly ? new RemoteReadableTable(this.tableSpec.getId(), readFn, readRateLimiter, tableExecutors.get(tableId), callbackExecutors.get(tableId)) : new RemoteReadWriteTable(this.tableSpec.getId(), readFn, writeFn, readRateLimiter, writeRateLimiter, tableExecutors.get(tableId), callbackExecutors.get(tableId));
        TableMetricsUtil metricsUtil = new TableMetricsUtil(this.context, (Table)table, tableId);
        if (readRetryPolicy != null) {
            ((RetriableReadFunction)readFn).setMetrics(metricsUtil);
        }
        if (writeRetryPolicy != null) {
            ((RetriableWriteFunction)writeFn).setMetrics(metricsUtil);
        }
        table.init(this.context);
        this.tables.add(table);
        return table;
    }

    public void close() {
        this.tables.forEach(t -> t.close());
        tableExecutors.values().forEach(e -> e.shutdown());
        callbackExecutors.values().forEach(e -> e.shutdown());
    }

    private <T> T deserializeObject(String key) {
        String entry = this.tableSpec.getConfig().getOrDefault(key, "");
        if (entry.isEmpty()) {
            return null;
        }
        return SerdeUtils.deserialize(key, entry);
    }

    private TableReadFunction<?, ?> getReadFn() {
        TableReadFunction readFn = (TableReadFunction)this.deserializeObject(READ_FN);
        if (readFn != null) {
            readFn.init(this.context);
        }
        return readFn;
    }

    private TableWriteFunction<?, ?> getWriteFn() {
        TableWriteFunction writeFn = (TableWriteFunction)this.deserializeObject(WRITE_FN);
        if (writeFn != null) {
            writeFn.init(this.context);
        }
        return writeFn;
    }
}

