/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.remote.descriptors;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.table.TableSpec;
import org.apache.samza.table.descriptors.BaseTableDescriptor;
import org.apache.samza.table.remote.TableRateLimiter;
import org.apache.samza.table.remote.TableReadFunction;
import org.apache.samza.table.remote.TableWriteFunction;
import org.apache.samza.table.remote.descriptors.RemoteTableProviderFactory;
import org.apache.samza.table.retry.TableRetryPolicy;
import org.apache.samza.table.utils.SerdeUtils;
import org.apache.samza.util.EmbeddedTaggedRateLimiter;
import org.apache.samza.util.RateLimiter;

public class RemoteTableDescriptor<K, V>
extends BaseTableDescriptor<K, V, RemoteTableDescriptor<K, V>> {
    public static final String RL_READ_TAG = "readTag";
    public static final String RL_WRITE_TAG = "writeTag";
    private TableReadFunction<K, V> readFn;
    private TableWriteFunction<K, V> writeFn;
    private RateLimiter rateLimiter;
    private Map<String, Integer> tagCreditsMap = new HashMap<String, Integer>();
    private TableRateLimiter.CreditFunction<K, V> readCreditFn;
    private TableRateLimiter.CreditFunction<K, V> writeCreditFn;
    private TableRetryPolicy readRetryPolicy;
    private TableRetryPolicy writeRetryPolicy;
    private int asyncCallbackPoolSize = -1;

    public RemoteTableDescriptor(String tableId) {
        super(tableId);
    }

    public RemoteTableDescriptor(String tableId, KVSerde<K, V> serde) {
        super(tableId, serde);
    }

    @Override
    public TableSpec getTableSpec() {
        this.validate();
        HashMap<String, String> tableSpecConfig = new HashMap<String, String>();
        this.generateTableSpecConfig(tableSpecConfig);
        tableSpecConfig.put("io.read.func", SerdeUtils.serialize("read function", this.readFn));
        if (this.writeFn != null) {
            tableSpecConfig.put("io.write.func", SerdeUtils.serialize("write function", this.writeFn));
        }
        if (!this.tagCreditsMap.isEmpty()) {
            tableSpecConfig.put("io.ratelimiter", SerdeUtils.serialize("rate limiter", new EmbeddedTaggedRateLimiter(this.tagCreditsMap)));
        } else if (this.rateLimiter != null) {
            tableSpecConfig.put("io.ratelimiter", SerdeUtils.serialize("rate limiter", this.rateLimiter));
        }
        if (this.readCreditFn != null) {
            tableSpecConfig.put("io.read.credit.func", SerdeUtils.serialize("read credit function", this.readCreditFn));
        }
        if (this.writeCreditFn != null) {
            tableSpecConfig.put("io.write.credit.func", SerdeUtils.serialize("write credit function", this.writeCreditFn));
        }
        if (this.readRetryPolicy != null) {
            tableSpecConfig.put("io.read.retry.policy", SerdeUtils.serialize("read retry policy", this.readRetryPolicy));
        }
        if (this.writeRetryPolicy != null) {
            tableSpecConfig.put("io.write.retry.policy", SerdeUtils.serialize("write retry policy", this.writeRetryPolicy));
        }
        tableSpecConfig.put("io.async.callback.pool.size", String.valueOf(this.asyncCallbackPoolSize));
        return new TableSpec(this.tableId, this.serde, RemoteTableProviderFactory.class.getName(), tableSpecConfig);
    }

    public RemoteTableDescriptor<K, V> withReadFunction(TableReadFunction<K, V> readFn) {
        Preconditions.checkNotNull(readFn, (Object)"null read function");
        this.readFn = readFn;
        return this;
    }

    public RemoteTableDescriptor<K, V> withWriteFunction(TableWriteFunction<K, V> writeFn) {
        Preconditions.checkNotNull(writeFn, (Object)"null write function");
        this.writeFn = writeFn;
        return this;
    }

    public RemoteTableDescriptor<K, V> withReadFunction(TableReadFunction<K, V> readFn, TableRetryPolicy retryPolicy) {
        Preconditions.checkNotNull(readFn, (Object)"null read function");
        Preconditions.checkNotNull((Object)retryPolicy, (Object)"null retry policy");
        this.readFn = readFn;
        this.readRetryPolicy = retryPolicy;
        return this;
    }

    public RemoteTableDescriptor<K, V> withWriteFunction(TableWriteFunction<K, V> writeFn, TableRetryPolicy retryPolicy) {
        Preconditions.checkNotNull(writeFn, (Object)"null write function");
        Preconditions.checkNotNull((Object)retryPolicy, (Object)"null retry policy");
        this.writeFn = writeFn;
        this.writeRetryPolicy = retryPolicy;
        return this;
    }

    public RemoteTableDescriptor<K, V> withRateLimiter(RateLimiter rateLimiter, TableRateLimiter.CreditFunction<K, V> readCreditFn, TableRateLimiter.CreditFunction<K, V> writeCreditFn) {
        Preconditions.checkNotNull((Object)rateLimiter, (Object)"null read rate limiter");
        this.rateLimiter = rateLimiter;
        this.readCreditFn = readCreditFn;
        this.writeCreditFn = writeCreditFn;
        return this;
    }

    public RemoteTableDescriptor<K, V> withReadRateLimit(int creditsPerSec) {
        Preconditions.checkArgument((creditsPerSec > 0 ? 1 : 0) != 0, (Object)"Max read rate must be a positive number.");
        this.tagCreditsMap.put(RL_READ_TAG, creditsPerSec);
        return this;
    }

    public RemoteTableDescriptor<K, V> withWriteRateLimit(int creditsPerSec) {
        Preconditions.checkArgument((creditsPerSec > 0 ? 1 : 0) != 0, (Object)"Max write rate must be a positive number.");
        this.tagCreditsMap.put(RL_WRITE_TAG, creditsPerSec);
        return this;
    }

    public RemoteTableDescriptor<K, V> withAsyncCallbackExecutorPoolSize(int poolSize) {
        this.asyncCallbackPoolSize = poolSize;
        return this;
    }

    @Override
    protected void validate() {
        super.validate();
        Preconditions.checkNotNull(this.readFn, (Object)"TableReadFunction is required.");
        Preconditions.checkArgument((this.rateLimiter == null || this.tagCreditsMap.isEmpty() ? 1 : 0) != 0, (Object)"Only one of rateLimiter instance or read/write limits can be specified");
        Preconditions.checkArgument((this.asyncCallbackPoolSize <= 20 ? 1 : 0) != 0, (Object)"too many threads for async callback executor.");
    }
}

