/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.remote;

import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.samza.SamzaException;
import org.apache.samza.annotation.InterfaceStability;
import org.apache.samza.operators.functions.ClosableFunction;
import org.apache.samza.operators.functions.InitableFunction;
import org.apache.samza.storage.kv.Entry;

@InterfaceStability.Unstable
public interface TableWriteFunction<K, V>
extends Serializable,
InitableFunction,
ClosableFunction {
    default public void put(K key, V record) {
        try {
            this.putAsync(key, record).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new SamzaException("PUT failed for " + key, (Throwable)e);
        }
    }

    public CompletableFuture<Void> putAsync(K var1, V var2);

    default public void putAll(List<Entry<K, V>> records) {
        try {
            this.putAllAsync(records).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new SamzaException("PUT_ALL failed for " + records, (Throwable)e);
        }
    }

    default public CompletableFuture<Void> putAllAsync(Collection<Entry<K, V>> records) {
        List putFutures = records.stream().map(e -> this.putAsync(e.getKey(), e.getValue())).collect(Collectors.toList());
        return CompletableFuture.allOf((CompletableFuture[])Iterables.toArray(putFutures, CompletableFuture.class));
    }

    default public void delete(K key) {
        try {
            this.deleteAsync(key).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new SamzaException("DELETE failed for " + key, (Throwable)e);
        }
    }

    public CompletableFuture<Void> deleteAsync(K var1);

    default public void deleteAll(Collection<K> keys) {
        try {
            this.deleteAllAsync(keys).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new SamzaException("DELETE failed for " + keys, (Throwable)e);
        }
    }

    default public CompletableFuture<Void> deleteAllAsync(Collection<K> keys) {
        List deleteFutures = keys.stream().map(this::deleteAsync).collect(Collectors.toList());
        return CompletableFuture.allOf((CompletableFuture[])Iterables.toArray(deleteFutures, CompletableFuture.class));
    }

    public boolean isRetriable(Throwable var1);

    default public void flush() {
    }
}

