/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.remote;

import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.samza.SamzaException;
import org.apache.samza.annotation.InterfaceStability;
import org.apache.samza.operators.functions.ClosableFunction;
import org.apache.samza.operators.functions.InitableFunction;

@InterfaceStability.Unstable
public interface TableReadFunction<K, V>
extends Serializable,
InitableFunction,
ClosableFunction {
    default public V get(K key) {
        try {
            return this.getAsync(key).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new SamzaException("GET failed for " + key, (Throwable)e);
        }
    }

    public CompletableFuture<V> getAsync(K var1);

    default public Map<K, V> getAll(Collection<K> keys) {
        try {
            return this.getAllAsync(keys).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new SamzaException("GET_ALL failed for " + keys, (Throwable)e);
        }
    }

    default public CompletableFuture<Map<K, V>> getAllAsync(Collection<K> keys) {
        Map<Object, CompletableFuture> getFutures = keys.stream().collect(Collectors.toMap(k -> k, k -> this.getAsync(k)));
        return CompletableFuture.allOf((CompletableFuture[])Iterables.toArray(getFutures.values(), CompletableFuture.class)).thenApply(future -> getFutures.entrySet().stream().collect(Collectors.toMap(e -> e.getKey(), e -> ((CompletableFuture)e.getValue()).join())));
    }

    public boolean isRetriable(Throwable var1);
}

