/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.remote;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import org.apache.samza.annotation.InterfaceStability;
import org.apache.samza.metrics.Timer;
import org.apache.samza.storage.kv.Entry;
import org.apache.samza.util.RateLimiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableRateLimiter<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(TableRateLimiter.class);
    private final String tag;
    private final boolean rateLimited;
    private final CreditFunction<K, V> creditFn;
    @VisibleForTesting
    final RateLimiter rateLimiter;
    private Timer waitTimeMetric;

    public TableRateLimiter(String tableId, RateLimiter rateLimiter, CreditFunction<K, V> creditFn, String tag) {
        this.rateLimiter = rateLimiter;
        this.creditFn = creditFn;
        this.tag = tag;
        this.rateLimited = rateLimiter != null && rateLimiter.getSupportedTags().contains(tag);
        LOG.info("Rate limiting is {} for {}", (Object)(this.rateLimited ? "enabled" : "disabled"), (Object)tableId);
    }

    public void setTimerMetric(Timer timer) {
        Preconditions.checkNotNull((Object)timer);
        this.waitTimeMetric = timer;
    }

    int getCredits(K key, V value) {
        return this.creditFn == null ? 1 : this.creditFn.getCredits(key, value);
    }

    int getCredits(Collection<K> keys) {
        if (this.creditFn == null) {
            return keys.size();
        }
        return keys.stream().mapToInt(k -> this.creditFn.getCredits(k, null)).sum();
    }

    int getEntryCredits(Collection<Entry<K, V>> entries) {
        if (this.creditFn == null) {
            return entries.size();
        }
        return entries.stream().mapToInt(e -> this.creditFn.getCredits(e.getKey(), e.getValue())).sum();
    }

    private void throttle(int credits) {
        if (!this.rateLimited) {
            return;
        }
        long startNs = System.nanoTime();
        this.rateLimiter.acquire(Collections.singletonMap(this.tag, credits));
        this.waitTimeMetric.update(System.nanoTime() - startNs);
    }

    public void throttle(K key) {
        this.throttle(this.getCredits(key, null));
    }

    public void throttle(K key, V value) {
        this.throttle(this.getCredits(key, value));
    }

    public void throttle(Collection<K> keys) {
        this.throttle(this.getCredits(keys));
    }

    public void throttleRecords(Collection<Entry<K, V>> records) {
        this.throttle(this.getEntryCredits(records));
    }

    public boolean isRateLimited() {
        return this.rateLimited;
    }

    @InterfaceStability.Unstable
    public static interface CreditFunction<K, V>
    extends Serializable {
        public int getCredits(K var1, V var2);
    }
}

