/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.remote;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.samza.SamzaException;
import org.apache.samza.context.Context;
import org.apache.samza.metrics.Timer;
import org.apache.samza.storage.kv.Entry;
import org.apache.samza.table.ReadableTable;
import org.apache.samza.table.Table;
import org.apache.samza.table.remote.TableRateLimiter;
import org.apache.samza.table.remote.TableReadFunction;
import org.apache.samza.table.utils.DefaultTableReadMetrics;
import org.apache.samza.table.utils.TableMetricsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteReadableTable<K, V>
implements ReadableTable<K, V> {
    protected final String tableId;
    protected final Logger logger;
    protected final ExecutorService callbackExecutor;
    protected final ExecutorService tableExecutor;
    protected final TableReadFunction<K, V> readFn;
    protected final TableRateLimiter<K, V> readRateLimiter;
    private DefaultTableReadMetrics readMetrics;

    public RemoteReadableTable(String tableId, TableReadFunction<K, V> readFn, TableRateLimiter<K, V> rateLimiter, ExecutorService tableExecutor, ExecutorService callbackExecutor) {
        Preconditions.checkArgument((tableId != null && !tableId.isEmpty() ? 1 : 0) != 0, (Object)"invalid table id");
        Preconditions.checkNotNull(readFn, (Object)"null read function");
        this.tableId = tableId;
        this.readFn = readFn;
        this.readRateLimiter = rateLimiter;
        this.callbackExecutor = callbackExecutor;
        this.tableExecutor = tableExecutor;
        this.logger = LoggerFactory.getLogger((String)(this.getClass().getName() + "-" + tableId));
    }

    public void init(Context context) {
        this.readMetrics = new DefaultTableReadMetrics(context, (Table)this, this.tableId);
        TableMetricsUtil tableMetricsUtil = new TableMetricsUtil(context, (Table)this, this.tableId);
        this.readRateLimiter.setTimerMetric(tableMetricsUtil.newTimer("get-throttle-ns"));
    }

    public V get(K key) {
        try {
            return this.getAsync(key).get();
        }
        catch (Exception e) {
            throw new SamzaException((Throwable)e);
        }
    }

    public CompletableFuture<V> getAsync(K key) {
        Preconditions.checkNotNull(key);
        this.readMetrics.numGets.inc();
        return this.execute(this.readRateLimiter, key, this.readFn::getAsync, this.readMetrics.getNs).exceptionally(e -> {
            throw new SamzaException("Failed to get the record for " + key, e);
        });
    }

    public Map<K, V> getAll(List<K> keys) {
        this.readMetrics.numGetAlls.inc();
        try {
            return this.getAllAsync(keys).get();
        }
        catch (Exception e) {
            throw new SamzaException((Throwable)e);
        }
    }

    public CompletableFuture<Map<K, V>> getAllAsync(List<K> keys) {
        Preconditions.checkNotNull(keys);
        if (keys.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.EMPTY_MAP);
        }
        this.readMetrics.numGetAlls.inc();
        return this.execute(this.readRateLimiter, (Collection<K>)keys, this.readFn::getAllAsync, this.readMetrics.getAllNs).handle((result, e) -> {
            if (e != null) {
                throw new SamzaException("Failed to get the records for " + keys, e);
            }
            return result;
        });
    }

    protected <T> CompletableFuture<T> execute(TableRateLimiter<K, V> rateLimiter, K key, Function<K, CompletableFuture<T>> method, Timer timer) {
        CompletableFuture<T> ioFuture;
        long startNs = System.nanoTime();
        CompletionStage<T> completionStage = ioFuture = rateLimiter.isRateLimited() ? CompletableFuture.runAsync(() -> rateLimiter.throttle(key), this.tableExecutor).thenCompose(r -> (CompletableFuture)method.apply(key)) : method.apply(key);
        if (this.callbackExecutor != null) {
            ioFuture.thenApplyAsync(r -> {
                timer.update(System.nanoTime() - startNs);
                return r;
            }, (Executor)this.callbackExecutor);
        } else {
            ioFuture.thenApply(r -> {
                timer.update(System.nanoTime() - startNs);
                return r;
            });
        }
        return ioFuture;
    }

    protected CompletableFuture<Void> execute(TableRateLimiter<K, V> rateLimiter, K key, V value, BiFunction<K, V, CompletableFuture<Void>> method, Timer timer) {
        CompletableFuture<Void> ioFuture;
        long startNs = System.nanoTime();
        CompletionStage<Void> completionStage = ioFuture = rateLimiter.isRateLimited() ? CompletableFuture.runAsync(() -> rateLimiter.throttle(key, value), this.tableExecutor).thenCompose(r -> (CompletableFuture)method.apply(key, value)) : method.apply(key, value);
        if (this.callbackExecutor != null) {
            ioFuture.thenApplyAsync(r -> {
                timer.update(System.nanoTime() - startNs);
                return r;
            }, (Executor)this.callbackExecutor);
        } else {
            ioFuture.thenApply(r -> {
                timer.update(System.nanoTime() - startNs);
                return r;
            });
        }
        return ioFuture;
    }

    protected <T> CompletableFuture<T> execute(TableRateLimiter<K, V> rateLimiter, Collection<K> keys, Function<Collection<K>, CompletableFuture<T>> method, Timer timer) {
        CompletableFuture<T> ioFuture;
        long startNs = System.nanoTime();
        CompletionStage<T> completionStage = ioFuture = rateLimiter.isRateLimited() ? CompletableFuture.runAsync(() -> rateLimiter.throttle(keys), this.tableExecutor).thenCompose(r -> (CompletableFuture)method.apply(keys)) : method.apply(keys);
        if (this.callbackExecutor != null) {
            ioFuture.thenApplyAsync(r -> {
                timer.update(System.nanoTime() - startNs);
                return r;
            }, (Executor)this.callbackExecutor);
        } else {
            ioFuture.thenApply(r -> {
                timer.update(System.nanoTime() - startNs);
                return r;
            });
        }
        return ioFuture;
    }

    protected CompletableFuture<Void> executeRecords(TableRateLimiter<K, V> rateLimiter, Collection<Entry<K, V>> records, Function<Collection<Entry<K, V>>, CompletableFuture<Void>> method, Timer timer) {
        long startNs = System.nanoTime();
        CompletionStage<Void> ioFuture = rateLimiter.isRateLimited() ? CompletableFuture.runAsync(() -> rateLimiter.throttleRecords(records), this.tableExecutor).thenCompose(r -> (CompletableFuture)method.apply(records)) : method.apply(records);
        if (this.callbackExecutor != null) {
            ioFuture.thenApplyAsync(r -> {
                timer.update(System.nanoTime() - startNs);
                return r;
            }, (Executor)this.callbackExecutor);
        } else {
            ioFuture.thenApply(r -> {
                timer.update(System.nanoTime() - startNs);
                return r;
            });
        }
        return ioFuture;
    }

    public void close() {
        this.readFn.close();
    }

    @VisibleForTesting
    public ExecutorService getCallbackExecutor() {
        return this.callbackExecutor;
    }

    @VisibleForTesting
    public ExecutorService getTableExecutor() {
        return this.tableExecutor;
    }

    @VisibleForTesting
    public TableReadFunction<K, V> getReadFn() {
        return this.readFn;
    }

    @VisibleForTesting
    public TableRateLimiter<K, V> getReadRateLimiter() {
        return this.readRateLimiter;
    }
}

