/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.remote;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.samza.SamzaException;
import org.apache.samza.context.Context;
import org.apache.samza.storage.kv.Entry;
import org.apache.samza.table.ReadWriteTable;
import org.apache.samza.table.Table;
import org.apache.samza.table.remote.RemoteReadableTable;
import org.apache.samza.table.remote.TableRateLimiter;
import org.apache.samza.table.remote.TableReadFunction;
import org.apache.samza.table.remote.TableWriteFunction;
import org.apache.samza.table.utils.DefaultTableWriteMetrics;
import org.apache.samza.table.utils.TableMetricsUtil;

public class RemoteReadWriteTable<K, V>
extends RemoteReadableTable<K, V>
implements ReadWriteTable<K, V> {
    private DefaultTableWriteMetrics writeMetrics;
    protected final TableWriteFunction<K, V> writeFn;
    protected final TableRateLimiter writeRateLimiter;

    public RemoteReadWriteTable(String tableId, TableReadFunction readFn, TableWriteFunction writeFn, TableRateLimiter<K, V> readRateLimiter, TableRateLimiter<K, V> writeRateLimiter, ExecutorService tableExecutor, ExecutorService callbackExecutor) {
        super(tableId, readFn, readRateLimiter, tableExecutor, callbackExecutor);
        Preconditions.checkNotNull((Object)writeFn, (Object)"null write function");
        this.writeFn = writeFn;
        this.writeRateLimiter = writeRateLimiter;
    }

    @Override
    public void init(Context context) {
        super.init(context);
        this.writeMetrics = new DefaultTableWriteMetrics(context, (Table)this, this.tableId);
        TableMetricsUtil tableMetricsUtil = new TableMetricsUtil(context, (Table)this, this.tableId);
        this.writeRateLimiter.setTimerMetric(tableMetricsUtil.newTimer("put-throttle-ns"));
    }

    public void put(K key, V value) {
        try {
            this.putAsync(key, value).get();
        }
        catch (Exception e) {
            throw new SamzaException((Throwable)e);
        }
    }

    public CompletableFuture<Void> putAsync(K key, V value) {
        Preconditions.checkNotNull(key);
        if (value == null) {
            return this.deleteAsync(key);
        }
        this.writeMetrics.numPuts.inc();
        return this.execute(this.writeRateLimiter, key, value, this.writeFn::putAsync, this.writeMetrics.putNs).exceptionally(e -> {
            throw new SamzaException("Failed to put a record with key=" + key, e);
        });
    }

    public void putAll(List<Entry<K, V>> entries) {
        try {
            this.putAllAsync(entries).get();
        }
        catch (Exception e) {
            throw new SamzaException((Throwable)e);
        }
    }

    public CompletableFuture<Void> putAllAsync(List<Entry<K, V>> records) {
        Preconditions.checkNotNull(records);
        if (records.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        this.writeMetrics.numPutAlls.inc();
        List deleteKeys = records.stream().filter(e -> e.getValue() == null).map(Entry::getKey).collect(Collectors.toList());
        CompletableFuture<Object> deleteFuture = deleteKeys.isEmpty() ? CompletableFuture.completedFuture(null) : this.deleteAllAsync(deleteKeys);
        List putRecords = records.stream().filter(e -> e.getValue() != null).collect(Collectors.toList());
        CompletableFuture[] completableFutureArray = new CompletableFuture[2];
        completableFutureArray[0] = deleteFuture;
        completableFutureArray[1] = this.executeRecords(this.writeRateLimiter, putRecords, this.writeFn::putAllAsync, this.writeMetrics.putAllNs);
        return CompletableFuture.allOf(completableFutureArray).exceptionally(e -> {
            String strKeys = records.stream().map(r -> r.getKey().toString()).collect(Collectors.joining(","));
            throw new SamzaException(String.format("Failed to put records with keys=" + strKeys, new Object[0]), e);
        });
    }

    public void delete(K key) {
        try {
            this.deleteAsync(key).get();
        }
        catch (Exception e) {
            throw new SamzaException((Throwable)e);
        }
    }

    public CompletableFuture<Void> deleteAsync(K key) {
        Preconditions.checkNotNull(key);
        this.writeMetrics.numDeletes.inc();
        return this.execute(this.writeRateLimiter, key, this.writeFn::deleteAsync, this.writeMetrics.deleteNs).exceptionally(e -> {
            throw new SamzaException(String.format("Failed to delete the record for " + key, new Object[0]), e);
        });
    }

    public void deleteAll(List<K> keys) {
        try {
            this.deleteAllAsync(keys).get();
        }
        catch (Exception e) {
            throw new SamzaException((Throwable)e);
        }
    }

    public CompletableFuture<Void> deleteAllAsync(List<K> keys) {
        Preconditions.checkNotNull(keys);
        if (keys.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        this.writeMetrics.numDeleteAlls.inc();
        return this.execute(this.writeRateLimiter, keys, this.writeFn::deleteAllAsync, this.writeMetrics.deleteAllNs).exceptionally(e -> {
            throw new SamzaException(String.format("Failed to delete records for " + keys, new Object[0]), e);
        });
    }

    public void flush() {
        try {
            this.writeMetrics.numFlushes.inc();
            long startNs = System.nanoTime();
            this.writeFn.flush();
            this.writeMetrics.flushNs.update(System.nanoTime() - startNs);
        }
        catch (Exception e) {
            String errMsg = "Failed to flush remote store";
            this.logger.error(errMsg, (Throwable)e);
            throw new SamzaException(errMsg, (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.writeFn.close();
        super.close();
    }

    @VisibleForTesting
    public TableWriteFunction<K, V> getWriteFn() {
        return this.writeFn;
    }

    @VisibleForTesting
    public TableRateLimiter getWriteRateLimiter() {
        return this.writeRateLimiter;
    }
}

