/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.descriptors;

import java.util.HashMap;
import java.util.Map;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.serializers.NoOpSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.table.TableSpec;
import org.apache.samza.table.descriptors.TableDescriptor;

public abstract class BaseTableDescriptor<K, V, D extends BaseTableDescriptor<K, V, D>>
implements TableDescriptor<K, V, D> {
    protected final String tableId;
    protected KVSerde<K, V> serde = KVSerde.of((Serde)new NoOpSerde(), (Serde)new NoOpSerde());
    protected final Map<String, String> config = new HashMap<String, String>();

    protected BaseTableDescriptor(String tableId) {
        this.tableId = tableId;
    }

    protected BaseTableDescriptor(String tableId, KVSerde<K, V> serde) {
        this.tableId = tableId;
        this.serde = serde;
    }

    public D withConfig(String key, String value) {
        this.config.put(key, value);
        return (D)this;
    }

    public String getTableId() {
        return this.tableId;
    }

    public KVSerde<K, V> getSerde() {
        return this.serde;
    }

    protected void generateTableSpecConfig(Map<String, String> tableSpecConfig) {
        tableSpecConfig.putAll(this.config);
    }

    protected void validate() {
    }

    public abstract TableSpec getTableSpec();
}

