/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.caching.guava.descriptors;

import com.google.common.cache.Cache;
import java.util.ArrayList;
import java.util.List;
import org.apache.samza.table.Table;
import org.apache.samza.table.TableSpec;
import org.apache.samza.table.caching.guava.GuavaCacheTable;
import org.apache.samza.table.utils.SerdeUtils;
import org.apache.samza.table.utils.descriptors.BaseTableProvider;

public class GuavaCacheTableProvider
extends BaseTableProvider {
    public static final String GUAVA_CACHE = "guavaCache";
    private List<GuavaCacheTable> guavaTables = new ArrayList<GuavaCacheTable>();

    public GuavaCacheTableProvider(TableSpec tableSpec) {
        super(tableSpec);
    }

    public Table getTable() {
        Cache guavaCache = (Cache)SerdeUtils.deserialize(GUAVA_CACHE, (String)this.tableSpec.getConfig().get(GUAVA_CACHE));
        GuavaCacheTable table = new GuavaCacheTable(this.tableSpec.getId(), guavaCache);
        table.init(this.context);
        this.guavaTables.add(table);
        return table;
    }

    public void close() {
        this.guavaTables.forEach(t -> t.close());
    }
}

