/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.caching.guava.descriptors;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import java.util.HashMap;
import org.apache.samza.table.TableSpec;
import org.apache.samza.table.caching.guava.descriptors.GuavaCacheTableProviderFactory;
import org.apache.samza.table.descriptors.BaseTableDescriptor;
import org.apache.samza.table.utils.SerdeUtils;

public class GuavaCacheTableDescriptor<K, V>
extends BaseTableDescriptor<K, V, GuavaCacheTableDescriptor<K, V>> {
    private Cache<K, V> cache;

    public GuavaCacheTableDescriptor(String tableId) {
        super(tableId);
    }

    @Override
    public TableSpec getTableSpec() {
        this.validate();
        HashMap<String, String> tableSpecConfig = new HashMap<String, String>();
        this.generateTableSpecConfig(tableSpecConfig);
        tableSpecConfig.put("guavaCache", SerdeUtils.serialize("Guava cache", this.cache));
        return new TableSpec(this.tableId, this.serde, GuavaCacheTableProviderFactory.class.getName(), tableSpecConfig);
    }

    public GuavaCacheTableDescriptor withCache(Cache<K, V> cache) {
        this.cache = cache;
        return this;
    }

    @Override
    protected void validate() {
        super.validate();
        Preconditions.checkArgument((this.cache != null ? 1 : 0) != 0, (Object)"Must provide a Guava cache instance.");
    }
}

