/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.caching.guava;

import com.google.common.cache.Cache;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.samza.SamzaException;
import org.apache.samza.context.Context;
import org.apache.samza.storage.kv.Entry;
import org.apache.samza.table.ReadWriteTable;
import org.apache.samza.table.Table;
import org.apache.samza.table.utils.TableMetricsUtil;

public class GuavaCacheTable<K, V>
implements ReadWriteTable<K, V> {
    private final String tableId;
    private final Cache<K, V> cache;

    public GuavaCacheTable(String tableId, Cache<K, V> cache) {
        this.tableId = tableId;
        this.cache = cache;
    }

    public void init(Context context) {
        TableMetricsUtil tableMetricsUtil = new TableMetricsUtil(context, (Table)this, this.tableId);
        tableMetricsUtil.newGauge("evict-count", () -> this.cache.stats().evictionCount());
    }

    public V get(K key) {
        try {
            return this.getAsync(key).get();
        }
        catch (Exception e) {
            throw new SamzaException("GET failed for " + key, (Throwable)e);
        }
    }

    public CompletableFuture<V> getAsync(K key) {
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        try {
            future.complete(this.cache.getIfPresent(key));
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public Map<K, V> getAll(List<K> keys) {
        try {
            return this.getAllAsync(keys).get();
        }
        catch (Exception e) {
            throw new SamzaException("GET_ALL failed for " + keys, (Throwable)e);
        }
    }

    public CompletableFuture<Map<K, V>> getAllAsync(List<K> keys) {
        CompletableFuture<Map<K, V>> future = new CompletableFuture<Map<K, V>>();
        try {
            future.complete((Map<K, V>)this.cache.getAllPresent(keys));
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public void put(K key, V value) {
        try {
            this.putAsync(key, value).get();
        }
        catch (Exception e) {
            throw new SamzaException("PUT failed for " + key, (Throwable)e);
        }
    }

    public CompletableFuture<Void> putAsync(K key, V value) {
        if (key == null) {
            return this.deleteAsync(key);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.cache.put(key, value);
            future.complete(null);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public void putAll(List<Entry<K, V>> entries) {
        try {
            this.putAllAsync(entries).get();
        }
        catch (Exception e) {
            throw new SamzaException("PUT_ALL failed", (Throwable)e);
        }
    }

    public CompletableFuture<Void> putAllAsync(List<Entry<K, V>> entries) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            ArrayList delKeys = new ArrayList();
            ArrayList putRecords = new ArrayList();
            entries.forEach(r -> {
                if (r.getValue() != null) {
                    putRecords.add(r);
                } else {
                    delKeys.add(r.getKey());
                }
            });
            this.cache.invalidateAll(delKeys);
            putRecords.forEach(e -> this.put(e.getKey(), e.getValue()));
            future.complete(null);
        }
        catch (Exception e2) {
            future.completeExceptionally(e2);
        }
        return future;
    }

    public void delete(K key) {
        try {
            this.deleteAsync(key).get();
        }
        catch (Exception e) {
            throw new SamzaException("DELETE failed", (Throwable)e);
        }
    }

    public CompletableFuture<Void> deleteAsync(K key) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.cache.invalidate(key);
            future.complete(null);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public void deleteAll(List<K> keys) {
        try {
            this.deleteAllAsync(keys).get();
        }
        catch (Exception e) {
            throw new SamzaException("DELETE_ALL failed", (Throwable)e);
        }
    }

    public CompletableFuture<Void> deleteAllAsync(List<K> keys) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.cache.invalidateAll(keys);
            future.complete(null);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public synchronized void flush() {
        this.cache.cleanUp();
    }

    public synchronized void close() {
        this.cache.invalidateAll();
    }
}

