/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.caching.descriptors;

import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.samza.table.ReadWriteTable;
import org.apache.samza.table.ReadableTable;
import org.apache.samza.table.Table;
import org.apache.samza.table.TableSpec;
import org.apache.samza.table.caching.CachingTable;
import org.apache.samza.table.caching.guava.GuavaCacheTable;
import org.apache.samza.table.utils.descriptors.BaseTableProvider;

public class CachingTableProvider
extends BaseTableProvider {
    public static final String REAL_TABLE_ID = "realTableId";
    public static final String CACHE_TABLE_ID = "cacheTableId";
    public static final String READ_TTL_MS = "readTtl";
    public static final String WRITE_TTL_MS = "writeTtl";
    public static final String CACHE_SIZE = "cacheSize";
    public static final String WRITE_AROUND = "writeAround";
    private final List<ReadWriteTable> defaultCaches = new ArrayList<ReadWriteTable>();

    public CachingTableProvider(TableSpec tableSpec) {
        super(tableSpec);
    }

    public Table getTable() {
        ReadWriteTable cache;
        String realTableId = (String)this.tableSpec.getConfig().get(REAL_TABLE_ID);
        ReadableTable table = (ReadableTable)this.context.getTaskContext().getTable(realTableId);
        String cacheTableId = (String)this.tableSpec.getConfig().get(CACHE_TABLE_ID);
        if (cacheTableId != null) {
            cache = (ReadWriteTable)this.context.getTaskContext().getTable(cacheTableId);
        } else {
            cache = this.createDefaultCacheTable(realTableId);
            this.defaultCaches.add(cache);
        }
        boolean isWriteAround = Boolean.parseBoolean((String)this.tableSpec.getConfig().get(WRITE_AROUND));
        CachingTable cachingTable = new CachingTable(this.tableSpec.getId(), table, cache, isWriteAround);
        cachingTable.init(this.context);
        return cachingTable;
    }

    public void close() {
        this.defaultCaches.forEach(c -> c.close());
    }

    private ReadWriteTable createDefaultCacheTable(String tableId) {
        long readTtlMs = Long.parseLong(this.tableSpec.getConfig().getOrDefault(READ_TTL_MS, "-1"));
        long writeTtlMs = Long.parseLong(this.tableSpec.getConfig().getOrDefault(WRITE_TTL_MS, "-1"));
        long cacheSize = Long.parseLong(this.tableSpec.getConfig().getOrDefault(CACHE_SIZE, "-1"));
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (readTtlMs != -1L) {
            cacheBuilder.expireAfterAccess(readTtlMs, TimeUnit.MILLISECONDS);
        }
        if (writeTtlMs != -1L) {
            cacheBuilder.expireAfterWrite(writeTtlMs, TimeUnit.MILLISECONDS);
        }
        if (cacheSize != -1L) {
            cacheBuilder.maximumSize(cacheSize);
        }
        this.logger.info(String.format("Creating default cache with: readTtl=%d, writeTtl=%d, maxSize=%d", readTtlMs, writeTtlMs, cacheSize));
        GuavaCacheTable cacheTable = new GuavaCacheTable(tableId + "-def-cache", cacheBuilder.build());
        cacheTable.init(this.context);
        return cacheTable;
    }
}

