/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.caching.descriptors;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.samza.table.TableSpec;
import org.apache.samza.table.caching.descriptors.CachingTableProviderFactory;
import org.apache.samza.table.descriptors.BaseHybridTableDescriptor;
import org.apache.samza.table.descriptors.BaseTableDescriptor;
import org.apache.samza.table.descriptors.TableDescriptor;

public class CachingTableDescriptor<K, V>
extends BaseHybridTableDescriptor<K, V, CachingTableDescriptor<K, V>> {
    private Duration readTtl;
    private Duration writeTtl;
    private long cacheSize;
    private TableDescriptor<K, V, ?> cache;
    private TableDescriptor<K, V, ?> table;
    private boolean isWriteAround;

    public CachingTableDescriptor(String tableId, TableDescriptor<K, V, ?> table) {
        super(tableId);
        this.table = table;
    }

    public CachingTableDescriptor(String tableId, TableDescriptor<K, V, ?> table, TableDescriptor<K, V, ?> cache) {
        this(tableId, table);
        this.cache = cache;
    }

    @Override
    public List<? extends TableDescriptor<K, V, ?>> getTableDescriptors() {
        return this.cache != null ? Arrays.asList(this.cache, this.table) : Arrays.asList(this.table);
    }

    @Override
    public TableSpec getTableSpec() {
        this.validate();
        HashMap<String, String> tableSpecConfig = new HashMap<String, String>();
        this.generateTableSpecConfig(tableSpecConfig);
        if (this.cache != null) {
            tableSpecConfig.put("cacheTableId", ((BaseTableDescriptor)this.cache).getTableSpec().getId());
        } else {
            if (this.readTtl != null) {
                tableSpecConfig.put("readTtl", String.valueOf(this.readTtl.toMillis()));
            }
            if (this.writeTtl != null) {
                tableSpecConfig.put("writeTtl", String.valueOf(this.writeTtl.toMillis()));
            }
            if (this.cacheSize > 0L) {
                tableSpecConfig.put("cacheSize", String.valueOf(this.cacheSize));
            }
        }
        tableSpecConfig.put("realTableId", ((BaseTableDescriptor)this.table).getTableSpec().getId());
        tableSpecConfig.put("writeAround", String.valueOf(this.isWriteAround));
        return new TableSpec(this.tableId, this.serde, CachingTableProviderFactory.class.getName(), tableSpecConfig);
    }

    public CachingTableDescriptor<K, V> withReadTtl(Duration readTtl) {
        this.readTtl = readTtl;
        return this;
    }

    public CachingTableDescriptor<K, V> withWriteTtl(Duration writeTtl) {
        this.writeTtl = writeTtl;
        return this;
    }

    public CachingTableDescriptor<K, V> withCacheSize(long cacheSize) {
        this.cacheSize = cacheSize;
        return this;
    }

    public CachingTableDescriptor<K, V> withWriteAround() {
        this.isWriteAround = true;
        return this;
    }

    @Override
    @VisibleForTesting
    public void validate() {
        super.validate();
        Preconditions.checkNotNull(this.table, (Object)"Actual table is required.");
        if (this.cache == null) {
            Preconditions.checkNotNull((Object)this.readTtl, (Object)"readTtl must be specified.");
        } else {
            Preconditions.checkArgument((this.readTtl == null && this.writeTtl == null && this.cacheSize == 0L ? 1 : 0) != 0, (Object)"Invalid to specify both {cache} and {readTtl|writeTtl|cacheSize} at the same time.");
        }
    }
}

