/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.JavaTableConfig;
import org.apache.samza.context.Context;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.table.Table;
import org.apache.samza.table.TableSpec;
import org.apache.samza.table.descriptors.TableProvider;
import org.apache.samza.table.descriptors.TableProviderFactory;
import org.apache.samza.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableManager {
    private final Logger logger = LoggerFactory.getLogger((String)TableManager.class.getName());
    private final Map<String, TableCtx> tableContexts = new HashMap<String, TableCtx>();
    private boolean initialized;

    public TableManager(Config config, Map<String, Serde<Object>> serdes) {
        new JavaTableConfig(config).getTableIds().forEach(tableId -> {
            String tableProviderFactory = (String)config.get((Object)String.format(JavaTableConfig.TABLE_PROVIDER_FACTORY, tableId));
            JavaTableConfig tableConfig = new JavaTableConfig(config);
            KVSerde serde = KVSerde.of((Serde)((Serde)serdes.get(tableConfig.getKeySerde((String)tableId))), (Serde)((Serde)serdes.get(tableConfig.getValueSerde((String)tableId))));
            TableSpec tableSpec = new TableSpec(tableId, serde, tableProviderFactory, (Map)config.subset(String.format("tables.%s", tableId) + "."));
            this.addTable(tableSpec);
            this.logger.info("Added table " + tableSpec.getId());
        });
    }

    public void init(Context context) {
        this.tableContexts.values().forEach(ctx -> ((TableCtx)ctx).tableProvider.init(context));
        this.initialized = true;
    }

    private void addTable(TableSpec tableSpec) {
        if (this.tableContexts.containsKey(tableSpec.getId())) {
            throw new SamzaException("Table " + tableSpec.getId() + " already exists");
        }
        TableCtx ctx = new TableCtx();
        TableProviderFactory tableProviderFactory = Util.getObj(tableSpec.getTableProviderFactoryClassName(), TableProviderFactory.class);
        ctx.tableProvider = tableProviderFactory.getTableProvider(tableSpec);
        ctx.tableSpec = tableSpec;
        this.tableContexts.put(tableSpec.getId(), ctx);
    }

    public void close() {
        this.tableContexts.values().forEach(ctx -> ((TableCtx)ctx).tableProvider.close());
    }

    public Table getTable(String tableId) {
        Preconditions.checkState((boolean)this.initialized, (Object)"TableManager has not been initialized.");
        TableCtx ctx = this.tableContexts.get(tableId);
        Preconditions.checkNotNull((Object)ctx, (Object)("Unknown tableId " + tableId));
        if (ctx.table == null) {
            ctx.table = ctx.tableProvider.getTable();
        }
        return ctx.table;
    }

    public static class TableCtx {
        private TableSpec tableSpec;
        private TableProvider tableProvider;
        private Table table;
    }
}

