/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.samza.config.Config;
import org.apache.samza.config.JavaTableConfig;
import org.apache.samza.operators.TableImpl;
import org.apache.samza.table.TableSpec;
import org.apache.samza.table.descriptors.BaseTableDescriptor;
import org.apache.samza.table.descriptors.TableDescriptor;
import org.apache.samza.table.descriptors.TableProvider;
import org.apache.samza.table.descriptors.TableProviderFactory;
import org.apache.samza.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableConfigGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(TableConfigGenerator.class);

    public static Map<String, String> generateConfigsForTableDescs(Config config, List<TableDescriptor> tableDescriptors) {
        return TableConfigGenerator.generateConfigsForTableSpecs(config, TableConfigGenerator.getTableSpecs(tableDescriptors));
    }

    public static Map<String, String> generateConfigsForTableSpecs(Config config, List<TableSpec> tableSpecs) {
        HashMap<String, String> tableConfigs = new HashMap<String, String>();
        tableSpecs.forEach(tableSpec -> {
            tableConfigs.put(String.format(JavaTableConfig.TABLE_PROVIDER_FACTORY, tableSpec.getId()), tableSpec.getTableProviderFactoryClassName());
            TableProviderFactory tableProviderFactory = Util.getObj(tableSpec.getTableProviderFactoryClassName(), TableProviderFactory.class);
            TableProvider tableProvider = tableProviderFactory.getTableProvider(tableSpec);
            tableConfigs.putAll(tableProvider.generateConfig(config, tableConfigs));
        });
        LOG.info("TableConfigGenerator has generated configs {}", tableConfigs);
        return tableConfigs;
    }

    public static List<TableSpec> getTableSpecs(List<TableDescriptor> tableDescs) {
        LinkedHashMap tableSpecs = new LinkedHashMap();
        tableDescs.forEach(tableDesc -> {
            TableSpec tableSpec = ((BaseTableDescriptor)tableDesc).getTableSpec();
            if (tableSpecs.containsKey(tableSpec)) {
                throw new IllegalStateException(String.format("getTable() invoked multiple times with the same tableId: %s", tableDesc.getTableId()));
            }
            tableSpecs.put(tableSpec, new TableImpl(tableSpec));
        });
        return new ArrayList<TableSpec>(tableSpecs.keySet());
    }
}

