/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.inmemory;

import com.google.common.base.Preconditions;
import org.apache.samza.Partition;
import org.apache.samza.system.OutgoingMessageEnvelope;
import org.apache.samza.system.SystemProducer;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.system.inmemory.InMemoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemorySystemProducer
implements SystemProducer {
    private static final Logger LOG = LoggerFactory.getLogger(InMemorySystemProducer.class);
    private final InMemoryManager memoryManager;
    private final String systemName;

    public InMemorySystemProducer(String systemName, InMemoryManager manager) {
        this.systemName = systemName;
        this.memoryManager = manager;
    }

    public void start() {
        LOG.info("Starting in memory system producer for {}", (Object)this.systemName);
    }

    public void stop() {
        LOG.info("Stopping in memory system producer for {}", (Object)this.systemName);
    }

    public void register(String source) {
        LOG.info("Registering source {} with in memory producer", (Object)source);
    }

    public void send(String source, OutgoingMessageEnvelope envelope) {
        Object key = envelope.getKey();
        Object message = envelope.getMessage();
        Object partitionKey = envelope.getPartitionKey() != null ? envelope.getPartitionKey() : (key != null ? key : message);
        Preconditions.checkNotNull((Object)partitionKey, (Object)("Failed to compute partition key for the message: " + envelope));
        int partition = Math.abs(partitionKey.hashCode()) % this.memoryManager.getPartitionCountForSystemStream(envelope.getSystemStream());
        SystemStreamPartition ssp = new SystemStreamPartition(envelope.getSystemStream(), new Partition(partition));
        this.memoryManager.put(ssp, key, message);
    }

    public void flush(String source) {
    }
}

