/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.inmemory;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.samza.config.Config;
import org.apache.samza.config.InMemorySystemConfig;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.system.SystemAdmin;
import org.apache.samza.system.SystemConsumer;
import org.apache.samza.system.SystemFactory;
import org.apache.samza.system.SystemProducer;
import org.apache.samza.system.inmemory.InMemoryManager;
import org.apache.samza.system.inmemory.InMemorySystemAdmin;
import org.apache.samza.system.inmemory.InMemorySystemConsumer;
import org.apache.samza.system.inmemory.InMemorySystemProducer;

public class InMemorySystemFactory
implements SystemFactory {
    private static final ConcurrentHashMap<String, InMemoryManager> IN_MEMORY_MANAGERS = new ConcurrentHashMap();

    public SystemConsumer getConsumer(String systemName, Config config, MetricsRegistry registry) {
        return new InMemorySystemConsumer(this.getOrDefaultInMemoryManagerByTestId(config));
    }

    public SystemProducer getProducer(String systemName, Config config, MetricsRegistry registry) {
        return new InMemorySystemProducer(systemName, this.getOrDefaultInMemoryManagerByTestId(config));
    }

    public SystemAdmin getAdmin(String systemName, Config config) {
        return new InMemorySystemAdmin(systemName, this.getOrDefaultInMemoryManagerByTestId(config));
    }

    private InMemoryManager getOrDefaultInMemoryManagerByTestId(Config config) {
        InMemorySystemConfig inMemorySystemConfig = new InMemorySystemConfig(config);
        return IN_MEMORY_MANAGERS.computeIfAbsent(inMemorySystemConfig.getInMemoryScope(), key -> new InMemoryManager());
    }
}

