/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.inmemory;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.samza.system.IncomingMessageEnvelope;
import org.apache.samza.system.SystemConsumer;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.system.inmemory.InMemoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemorySystemConsumer
implements SystemConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(InMemorySystemConsumer.class);
    private final InMemoryManager memoryManager;
    private final Map<SystemStreamPartition, String> sspToOffset;

    public InMemorySystemConsumer(InMemoryManager manager) {
        this.memoryManager = manager;
        this.sspToOffset = new ConcurrentHashMap<SystemStreamPartition, String>();
    }

    public void start() {
        LOG.info("Starting in memory system consumer...");
    }

    public void stop() {
        LOG.info("Stopping in memory system consumer...");
    }

    public void register(SystemStreamPartition systemStreamPartition, String offset) {
        LOG.info("Registering ssp {} with starting offset {}", (Object)systemStreamPartition, (Object)offset);
        this.sspToOffset.put(systemStreamPartition, offset);
    }

    public Map<SystemStreamPartition, List<IncomingMessageEnvelope>> poll(Set<SystemStreamPartition> systemStreamPartitions, long timeout) throws InterruptedException {
        Map<SystemStreamPartition, String> sspOffsetPairToFetch = this.sspToOffset.entrySet().stream().filter(entry -> systemStreamPartitions.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<SystemStreamPartition, List<IncomingMessageEnvelope>> result = this.memoryManager.poll(sspOffsetPairToFetch);
        for (Map.Entry<SystemStreamPartition, List<IncomingMessageEnvelope>> sspToMessage : result.entrySet()) {
            this.sspToOffset.computeIfPresent(sspToMessage.getKey(), (ssp, offset) -> {
                int newOffset = Integer.parseInt(offset) + ((List)sspToMessage.getValue()).size();
                return String.valueOf(newOffset);
            });
        }
        return result;
    }
}

