/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.inmemory;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.samza.system.StreamSpec;
import org.apache.samza.system.StreamValidationException;
import org.apache.samza.system.SystemAdmin;
import org.apache.samza.system.SystemStreamMetadata;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.system.inmemory.InMemoryManager;

public class InMemorySystemAdmin
implements SystemAdmin {
    private final InMemoryManager inMemoryManager;
    private final String systemName;

    public InMemorySystemAdmin(String systemName, InMemoryManager manager) {
        this.inMemoryManager = manager;
        this.systemName = systemName;
    }

    public void start() {
    }

    public void stop() {
    }

    public Map<SystemStreamPartition, String> getOffsetsAfter(Map<SystemStreamPartition, String> offsets) {
        return offsets.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            String offset = (String)entry.getValue();
            return String.valueOf(Integer.valueOf(offset) + 1);
        }));
    }

    public Map<String, SystemStreamMetadata> getSystemStreamMetadata(Set<String> streamNames) {
        return this.inMemoryManager.getSystemStreamMetadata(this.systemName, streamNames);
    }

    public Integer offsetComparator(String offset1, String offset2) {
        if (offset1 == null || offset2 == null) {
            return null;
        }
        return Integer.compare(Integer.parseInt(offset1), Integer.parseInt(offset2));
    }

    public boolean createStream(StreamSpec streamSpec) {
        return this.inMemoryManager.initializeStream(streamSpec);
    }

    public void validateStream(StreamSpec streamSpec) throws StreamValidationException {
    }

    public boolean clearStream(StreamSpec streamSpec) {
        return false;
    }
}

