/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.inmemory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.samza.Partition;
import org.apache.samza.system.EndOfStreamMessage;
import org.apache.samza.system.IncomingMessageEnvelope;
import org.apache.samza.system.StreamSpec;
import org.apache.samza.system.SystemStream;
import org.apache.samza.system.SystemStreamMetadata;
import org.apache.samza.system.SystemStreamPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InMemoryManager {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryManager.class);
    private static final int DEFAULT_PARTITION_COUNT = 1;
    private final ConcurrentHashMap<SystemStreamPartition, List<IncomingMessageEnvelope>> bufferedMessages = new ConcurrentHashMap();
    private final Map<SystemStream, Integer> systemStreamToPartitions = new ConcurrentHashMap<SystemStream, Integer>();

    private List<IncomingMessageEnvelope> newSynchronizedLinkedList() {
        return Collections.synchronizedList(new LinkedList());
    }

    void put(SystemStreamPartition ssp, Object key, Object message) {
        List<IncomingMessageEnvelope> messages = this.bufferedMessages.get(ssp);
        String offset = String.valueOf(messages.size());
        if (message instanceof EndOfStreamMessage) {
            offset = IncomingMessageEnvelope.END_OF_STREAM_OFFSET;
        }
        IncomingMessageEnvelope messageEnvelope = new IncomingMessageEnvelope(ssp, offset, key, message);
        this.bufferedMessages.get(ssp).add(messageEnvelope);
    }

    Map<SystemStreamPartition, List<IncomingMessageEnvelope>> poll(Map<SystemStreamPartition, String> sspsToOffsets) {
        return sspsToOffsets.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.poll((SystemStreamPartition)entry.getKey(), (String)entry.getValue())));
    }

    boolean initializeStream(StreamSpec streamSpec) {
        LOG.info("Initializing the stream for {}", (Object)streamSpec.getId());
        this.systemStreamToPartitions.put(streamSpec.toSystemStream(), streamSpec.getPartitionCount());
        for (int partition = 0; partition < streamSpec.getPartitionCount(); ++partition) {
            this.bufferedMessages.put(new SystemStreamPartition(streamSpec.toSystemStream(), new Partition(partition)), this.newSynchronizedLinkedList());
        }
        return true;
    }

    Map<String, SystemStreamMetadata> getSystemStreamMetadata(String systemName, Set<String> streamNames) {
        Map<String, Map<SystemStreamPartition, List>> result = this.bufferedMessages.entrySet().stream().filter(entry -> systemName.equals(((SystemStreamPartition)entry.getKey()).getSystem()) && streamNames.contains(((SystemStreamPartition)entry.getKey()).getStream())).collect(Collectors.groupingBy(entry -> ((SystemStreamPartition)entry.getKey()).getStream(), Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        return result.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.constructSystemStreamMetadata((String)entry.getKey(), (Map)entry.getValue())));
    }

    int getPartitionCountForSystemStream(SystemStream systemStream) {
        return this.systemStreamToPartitions.getOrDefault(systemStream, 1);
    }

    private SystemStreamMetadata constructSystemStreamMetadata(String streamName, Map<SystemStreamPartition, List<IncomingMessageEnvelope>> sspToMessagesForSystem) {
        Map<Partition, SystemStreamMetadata.SystemStreamPartitionMetadata> partitionMetadata = sspToMessagesForSystem.entrySet().stream().collect(Collectors.toMap(entry -> ((SystemStreamPartition)entry.getKey()).getPartition(), entry -> {
            String oldestOffset = "0";
            String newestOffset = String.valueOf(((List)entry.getValue()).size());
            String upcomingOffset = String.valueOf(((List)entry.getValue()).size() + 1);
            return new SystemStreamMetadata.SystemStreamPartitionMetadata(oldestOffset, newestOffset, upcomingOffset);
        }));
        return new SystemStreamMetadata(streamName, partitionMetadata);
    }

    private List<IncomingMessageEnvelope> poll(SystemStreamPartition ssp, String offset) {
        List messageEnvelopesForSSP;
        int startingOffset = Integer.parseInt(offset);
        if (startingOffset >= (messageEnvelopesForSSP = (List)this.bufferedMessages.getOrDefault(ssp, new LinkedList())).size()) {
            return new ArrayList<IncomingMessageEnvelope>();
        }
        return messageEnvelopesForSSP.subList(startingOffset, messageEnvelopesForSSP.size());
    }
}

