/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.filereader;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.RandomAccessFile;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.system.IncomingMessageEnvelope;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.system.filereader.FileReaderSystemConsumer$;
import org.apache.samza.util.BlockingEnvelopeMap;
import org.apache.samza.util.Logging;
import org.apache.samza.util.Logging$class;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001B\u0001\u0003\u00015\u0011\u0001DR5mKJ+\u0017\rZ3s'f\u001cH/Z7D_:\u001cX/\\3s\u0015\t\u0019A!\u0001\u0006gS2,'/Z1eKJT!!\u0002\u0004\u0002\rML8\u000f^3n\u0015\t9\u0001\"A\u0003tC6T\u0018M\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"BA\t\u0007\u0003\u0011)H/\u001b7\n\u0005M\u0001\"a\u0005\"m_\u000e\\\u0017N\\4F]Z,Gn\u001c9f\u001b\u0006\u0004\bCA\b\u0016\u0013\t1\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011a\u0001!\u0011!Q\u0001\ne\t!b]=ti\u0016lg*Y7f!\tQ\u0002E\u0004\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyB$\u0001\u0004Qe\u0016$WMZ\u0005\u0003C\t\u0012aa\u0015;sS:<'BA\u0010\u001d\u0011!!\u0003A!A!\u0002\u0013)\u0013aD7fiJL7m\u001d*fO&\u001cHO]=\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!2\u0011aB7fiJL7m]\u0005\u0003U\u001d\u0012q\"T3ue&\u001c7OU3hSN$(/\u001f\u0005\tY\u0001\u0011\t\u0011)A\u0005[\u0005I\u0011/^3vKNK'0\u001a\t\u000379J!a\f\u000f\u0003\u0007%sG\u000f\u0003\u00052\u0001\t\u0005\t\u0015!\u0003.\u00039\u0001x\u000e\u001c7j]\u001e\u001cF.Z3q\u001bNDQa\r\u0001\u0005\u0002Q\na\u0001P5oSRtD#B\u001b8qeR\u0004C\u0001\u001c\u0001\u001b\u0005\u0011\u0001\"\u0002\r3\u0001\u0004I\u0002\"\u0002\u00133\u0001\u0004)\u0003b\u0002\u00173!\u0003\u0005\r!\f\u0005\bcI\u0002\n\u00111\u0001.\u0011\u001da\u0004\u00011A\u0005\u0002u\nae]=ti\u0016l7\u000b\u001e:fC6\u0004\u0016M\u001d;ji&|g.\u00118e'R\f'\u000f^5oO>3gm]3u+\u0005q\u0004\u0003B E\rfi\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bq!\\;uC\ndWM\u0003\u0002D9\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0015\u0003%aA'baB\u0011q\tS\u0007\u0002\t%\u0011\u0011\n\u0002\u0002\u0016'f\u001cH/Z7TiJ,\u0017-\u001c)beRLG/[8o\u0011\u001dY\u0005\u00011A\u0005\u00021\u000b!f]=ti\u0016l7\u000b\u001e:fC6\u0004\u0016M\u001d;ji&|g.\u00118e'R\f'\u000f^5oO>3gm]3u?\u0012*\u0017\u000f\u0006\u0002N!B\u00111DT\u0005\u0003\u001fr\u0011A!\u00168ji\"9\u0011KSA\u0001\u0002\u0004q\u0014a\u0001=%c!11\u000b\u0001Q!\ny\nqe]=ti\u0016l7\u000b\u001e:fC6\u0004\u0016M\u001d;ji&|g.\u00118e'R\f'\u000f^5oO>3gm]3uA!9Q\u000b\u0001a\u0001\n\u00031\u0016\u0001\u00029p_2,\u0012a\u0016\t\u00031zk\u0011!\u0017\u0006\u00035n\u000b!bY8oGV\u0014(/\u001a8u\u0015\t\tBLC\u0001^\u0003\u0011Q\u0017M^1\n\u0005}K&aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\t\u000f\u0005\u0004\u0001\u0019!C\u0001E\u0006A\u0001o\\8m?\u0012*\u0017\u000f\u0006\u0002NG\"9\u0011\u000bYA\u0001\u0002\u00049\u0006BB3\u0001A\u0003&q+A\u0003q_>d\u0007\u0005C\u0003h\u0001\u0011\u0005\u0003.\u0001\u0005sK\u001eL7\u000f^3s)\ri\u0015n\u001b\u0005\u0006U\u001a\u0004\rAR\u0001\u0016gf\u001cH/Z7TiJ,\u0017-\u001c)beRLG/[8o\u0011\u0015ag\r1\u0001\u001a\u00039\u0019H/\u0019:uS:<wJ\u001a4tKRDQA\u001c\u0001\u0005B=\fQa\u001d;beR$\u0012!\u0014\u0005\u0006c\u0002!\te\\\u0001\u0005gR|\u0007\u000fC\u0003t\u0001\u0011%A/\u0001\bsK\u0006$\u0017J\u001c9vi\u001aKG.Z:\u0015\u000bU\fI\"!\b\u0013\u0007YDhP\u0002\u0003xe\u0002)(\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004CA=}\u001b\u0005Q(BA>]\u0003\u0011a\u0017M\\4\n\u0005uT(AB(cU\u0016\u001cG\u000f\u0005\u0002z\u007f&\u0019\u0011\u0011\u0001>\u0003\u0011I+hN\\1cY\u0016D\u0011\"!\u0002w\u0001\u0004%\t!a\u0002\u0002\u0011MDW\u000f\u001e3po:,\"!!\u0003\u0011\u0007m\tY!C\u0002\u0002\u000eq\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002\u0012Y\u0004\r\u0011\"\u0001\u0002\u0014\u0005a1\u000f[;uI><hn\u0018\u0013fcR\u0019Q*!\u0006\t\u0013E\u000by!!AA\u0002\u0005%\u0001\"B9w\t\u0003y\u0007BBA\u000ee\u0002\u0007a)A\u0002tgBDQ\u0001\u001c:A\u0002eAq!!\t\u0001\t\u0003\n\u0019#\u0001\toK^\u0014En\\2lS:<\u0017+^3vKR\u0011\u0011Q\u0005\t\u00061\u0006\u001d\u00121F\u0005\u0004\u0003SI&a\u0005'j].,GM\u00117pG.LgnZ)vKV,\u0007cA$\u0002.%\u0019\u0011q\u0006\u0003\u0003/%s7m\\7j]\u001elUm]:bO\u0016,eN^3m_B,\u0007\u0002DA\u001a\u0001A\u0005\t\u0011!A\u0005\u0002\u0005U\u0012!\u00049s_R,7\r^3eIA,H\u000f\u0006\u0003\u00028\u0005}B#B'\u0002:\u0005m\u0002\u0002C)\u00022\u0005\u0005\t\u0019\u0001$\t\u0015\u0005u\u0012\u0011GA\u0001\u0002\u0004\tY#A\u0002yIIB\u0001\"UA\u0019\u0003\u0003\u0005\r!\u000e\u0005\r\u0003\u0007\u0002\u0001\u0013!A\u0001\u0002\u0013\u0005\u0011QI\u0001\u0016aJ|G/Z2uK\u0012$3/\u001a;Jg\u0006#\b*Z1e)\u0011\t9%!\u0015\u0015\r\u0005%\u0013QJA(!\rI\u00181J\u0005\u0004\u0003\u001bQ\b\u0002C)\u0002B\u0005\u0005\t\u0019\u0001$\t\u0015\u0005u\u0012\u0011IA\u0001\u0002\u0004\tI\u0001\u0003\u0005R\u0003\u0003\n\t\u00111\u00016\u000f%\t)FAA\u0001\u0012\u0003\t9&\u0001\rGS2,'+Z1eKJ\u001c\u0016p\u001d;f[\u000e{gn];nKJ\u00042ANA-\r!\t!!!A\t\u0002\u0005m3\u0003BA-\u0003;\u00022aGA0\u0013\r\t\t\u0007\b\u0002\u0007\u0003:L(+\u001a4\t\u000fM\nI\u0006\"\u0001\u0002fQ\u0011\u0011q\u000b\u0005\u000b\u0003S\nI&%A\u0005\u0002\u0005-\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0002n)\u001aQ&a\u001c,\u0005\u0005E\u0004\u0003BA:\u0003{j!!!\u001e\u000b\t\u0005]\u0014\u0011P\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u001f\u001d\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u007f\n)HA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!\"a!\u0002ZE\u0005I\u0011AA6\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0001")
public class FileReaderSystemConsumer
extends BlockingEnvelopeMap
implements Logging {
    private final int queueSize;
    public final int org$apache$samza$system$filereader$FileReaderSystemConsumer$$pollingSleepMs;
    private Map<SystemStreamPartition, String> systemStreamPartitionAndStartingOffset;
    private ExecutorService pool;
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private volatile byte bitmap$0;

    public static int $lessinit$greater$default$4() {
        return FileReaderSystemConsumer$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return FileReaderSystemConsumer$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        FileReaderSystemConsumer fileReaderSystemConsumer = this;
        synchronized (fileReaderSystemConsumer) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        FileReaderSystemConsumer fileReaderSystemConsumer = this;
        synchronized (fileReaderSystemConsumer) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging$class.startupLogger(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    @Override
    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    @Override
    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    @Override
    public void startupLog(Function0<Object> message) {
        Logging$class.startupLog(this, message);
    }

    @Override
    public void trace(Function0<Object> message) {
        Logging$class.trace(this, message);
    }

    @Override
    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.trace(this, message, e);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging$class.debug(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.debug(this, message, e);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging$class.info(this, message);
    }

    @Override
    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.info(this, message, e);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging$class.warn(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.warn(this, message, e);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging$class.error(this, message);
    }

    @Override
    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.error(this, message, e);
    }

    @Override
    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging$class.putMDC(this, key, value);
    }

    @Override
    public String getMDC(Function0<String> key) {
        return Logging$class.getMDC(this, key);
    }

    @Override
    public void removeMDC(Function0<String> key) {
        Logging$class.removeMDC(this, key);
    }

    @Override
    public void clearMDC() {
        Logging$class.clearMDC(this);
    }

    public /* synthetic */ void protected$put(FileReaderSystemConsumer x$1, SystemStreamPartition x$12, IncomingMessageEnvelope x$2) {
        x$1.put(x$12, x$2);
    }

    public /* synthetic */ Boolean protected$setIsAtHead(FileReaderSystemConsumer x$1, SystemStreamPartition x$12, boolean x$2) {
        return x$1.setIsAtHead(x$12, x$2);
    }

    public Map<SystemStreamPartition, String> systemStreamPartitionAndStartingOffset() {
        return this.systemStreamPartitionAndStartingOffset;
    }

    public void systemStreamPartitionAndStartingOffset_$eq(Map<SystemStreamPartition, String> x$1) {
        this.systemStreamPartitionAndStartingOffset = x$1;
    }

    public ExecutorService pool() {
        return this.pool;
    }

    public void pool_$eq(ExecutorService x$1) {
        this.pool = x$1;
    }

    public void register(SystemStreamPartition systemStreamPartition, String startingOffset) {
        super.register(systemStreamPartition, startingOffset);
        this.systemStreamPartitionAndStartingOffset().$plus$eq(new Tuple2((Object)systemStreamPartition, (Object)startingOffset));
    }

    public void start() {
        this.pool_$eq(Executors.newFixedThreadPool(this.systemStreamPartitionAndStartingOffset().size(), new ThreadFactoryBuilder().setNameFormat("Samza FileReader Thread-%d").setDaemon(true).build()));
        this.systemStreamPartitionAndStartingOffset().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileReaderSystemConsumer $outer;

            public final void apply(Tuple2<SystemStreamPartition, String> x0$1) {
                Tuple2<SystemStreamPartition, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    SystemStreamPartition ssp = (SystemStreamPartition)tuple2._1();
                    String offset = (String)tuple2._2();
                    this.$outer.pool().execute(this.$outer.org$apache$samza$system$filereader$FileReaderSystemConsumer$$readInputFiles(ssp, offset));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void stop() {
        this.pool().shutdown();
    }

    public Runnable org$apache$samza$system$filereader$FileReaderSystemConsumer$$readInputFiles(SystemStreamPartition ssp, String startingOffset) {
        return new Runnable(this, ssp, startingOffset){
            private volatile boolean shutdown;
            private final /* synthetic */ FileReaderSystemConsumer $outer;
            private final SystemStreamPartition ssp$1;
            private final String startingOffset$1;

            public boolean shutdown() {
                return this.shutdown;
            }

            public void shutdown_$eq(boolean x$1) {
                this.shutdown = x$1;
            }

            public void run() {
                String path = this.ssp$1.getStream();
                RandomAccessFile file = null;
                long filePointer = new StringOps(Predef$.MODULE$.augmentString(this.startingOffset$1)).toLong();
                String line = "";
                long offset = filePointer;
                try {
                    try {
                        file = new RandomAccessFile(path, "r");
                        while (!this.shutdown()) {
                            Object object;
                            if (file.length() <= filePointer) {
                                Thread.sleep(this.$outer.org$apache$samza$system$filereader$FileReaderSystemConsumer$$pollingSleepMs);
                                file.close();
                                file = new RandomAccessFile(path, "r");
                                object = BoxedUnit.UNIT;
                                continue;
                            }
                            file.seek(filePointer);
                            for (long i = filePointer; i < file.length(); ++i) {
                                char cha = (char)file.read();
                                if (cha == '\n') {
                                    this.$outer.protected$put(this.$outer, this.ssp$1, new IncomingMessageEnvelope(this.ssp$1, ((Object)BoxesRunTime.boxToLong((long)offset)).toString(), null, (Object)line));
                                    offset = i + 1L;
                                    line = "";
                                    continue;
                                }
                                line = new StringBuilder().append((Object)line).append((Object)BoxesRunTime.boxToCharacter((char)cha)).toString();
                            }
                            filePointer = file.length();
                            object = this.$outer.protected$setIsAtHead(this.$outer, this.ssp$1, true);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        this.$outer.info((Function0<Object>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Received an interrupt while reading file. Shutting down.";
                            }
                        });
                    }
                }
                finally {
                    if (file != null) {
                        file.close();
                    }
                }
            }

            public void stop() {
                this.shutdown_$eq(true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ssp$1 = ssp$1;
                this.startingOffset$1 = startingOffset$1;
                this.shutdown = false;
            }
        };
    }

    public LinkedBlockingQueue<IncomingMessageEnvelope> newBlockingQueue() {
        return new LinkedBlockingQueue<IncomingMessageEnvelope>(this.queueSize);
    }

    public FileReaderSystemConsumer(String systemName, MetricsRegistry metricsRegistry, int queueSize, int pollingSleepMs) {
        this.queueSize = queueSize;
        this.org$apache$samza$system$filereader$FileReaderSystemConsumer$$pollingSleepMs = pollingSleepMs;
        Logging$class.$init$(this);
        this.systemStreamPartitionAndStartingOffset = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.pool = null;
    }
}

