/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system;

import org.apache.samza.SamzaException;
import org.apache.samza.metrics.Counter;
import org.apache.samza.serializers.SerdeManager;
import org.apache.samza.system.OutgoingMessageEnvelope;
import org.apache.samza.system.SystemProducer;
import org.apache.samza.system.SystemProducers$;
import org.apache.samza.system.SystemProducersMetrics;
import org.apache.samza.util.Logging;
import org.apache.samza.util.Logging$class;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001Q4A!\u0001\u0002\u0001\u0017\ty1+_:uK6\u0004&o\u001c3vG\u0016\u00148O\u0003\u0002\u0004\t\u000511/_:uK6T!!\u0002\u0004\u0002\u000bM\fWN_1\u000b\u0005\u001dA\u0011AB1qC\u000eDWMC\u0001\n\u0003\ry'oZ\u0002\u0001'\r\u0001AB\u0005\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U!\u0011\u0001B;uS2L!a\u0006\u000b\u0003\u000f1{wmZ5oO\"A\u0011\u0004\u0001B\u0001B\u0003%!$A\u0005qe>$WoY3sgB!1DH\u0011%\u001d\tiA$\u0003\u0002\u001e\u001d\u00051\u0001K]3eK\u001aL!a\b\u0011\u0003\u00075\u000b\u0007O\u0003\u0002\u001e\u001dA\u00111DI\u0005\u0003G\u0001\u0012aa\u0015;sS:<\u0007CA\u0013'\u001b\u0005\u0011\u0011BA\u0014\u0003\u00059\u0019\u0016p\u001d;f[B\u0013x\u000eZ;dKJD\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IAK\u0001\rg\u0016\u0014H-Z'b]\u0006<WM\u001d\t\u0003W9j\u0011\u0001\f\u0006\u0003[\u0011\t1b]3sS\u0006d\u0017N_3sg&\u0011q\u0006\f\u0002\r'\u0016\u0014H-Z'b]\u0006<WM\u001d\u0005\tc\u0001\u0011\t\u0011)A\u0005e\u00059Q.\u001a;sS\u000e\u001c\bCA\u00134\u0013\t!$A\u0001\fTsN$X-\u001c)s_\u0012,8-\u001a:t\u001b\u0016$(/[2t\u0011!1\u0004A!A!\u0002\u00139\u0014A\u00063s_B\u001cVM]5bY&T\u0018\r^5p]\u0016\u0013(o\u001c:\u0011\u00055A\u0014BA\u001d\u000f\u0005\u001d\u0011un\u001c7fC:DQa\u000f\u0001\u0005\u0002q\na\u0001P5oSRtD#B\u001f?\u007f\u0001\u000b\u0005CA\u0013\u0001\u0011\u0015I\"\b1\u0001\u001b\u0011\u0015I#\b1\u0001+\u0011\u001d\t$\b%AA\u0002IBqA\u000e\u001e\u0011\u0002\u0003\u0007q\u0007C\u0003D\u0001\u0011\u0005A)A\u0003ti\u0006\u0014H/F\u0001F!\tia)\u0003\u0002H\u001d\t!QK\\5u\u0011\u0015I\u0005\u0001\"\u0001E\u0003\u0011\u0019Ho\u001c9\t\u000b-\u0003A\u0011\u0001'\u0002\u0011I,w-[:uKJ$\"!R'\t\u000b9S\u0005\u0019A\u0011\u0002\rM|WO]2f\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0003\u00151G.^:i)\t)%\u000bC\u0003O\u001f\u0002\u0007\u0011\u0005C\u0003U\u0001\u0011\u0005Q+\u0001\u0003tK:$GcA#W/\")aj\u0015a\u0001C!)\u0001l\u0015a\u00013\u0006AQM\u001c<fY>\u0004X\r\u0005\u0002&5&\u00111L\u0001\u0002\u0018\u001fV$xm\\5oO6+7o]1hK\u0016sg/\u001a7pa\u0016<q!\u0018\u0002\u0002\u0002#\u0005a,A\bTsN$X-\u001c)s_\u0012,8-\u001a:t!\t)sLB\u0004\u0002\u0005\u0005\u0005\t\u0012\u00011\u0014\u0005}c\u0001\"B\u001e`\t\u0003\u0011G#\u00010\t\u000f\u0011|\u0016\u0013!C\u0001K\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\u0012A\u001a\u0016\u0003e\u001d\\\u0013\u0001\u001b\t\u0003S:l\u0011A\u001b\u0006\u0003W2\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u00055t\u0011AC1o]>$\u0018\r^5p]&\u0011qN\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007bB9`#\u0003%\tA]\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0003MT#aN4")
public class SystemProducers
implements Logging {
    public final Map<String, SystemProducer> org$apache$samza$system$SystemProducers$$producers;
    private final SerdeManager serdeManager;
    private final SystemProducersMetrics metrics;
    private final boolean dropSerializationError;
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private volatile byte bitmap$0;

    public static boolean $lessinit$greater$default$4() {
        return SystemProducers$.MODULE$.$lessinit$greater$default$4();
    }

    public static SystemProducersMetrics $lessinit$greater$default$3() {
        return SystemProducers$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        SystemProducers systemProducers = this;
        synchronized (systemProducers) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        SystemProducers systemProducers = this;
        synchronized (systemProducers) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging$class.startupLogger(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    @Override
    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    @Override
    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    @Override
    public void startupLog(Function0<Object> message) {
        Logging$class.startupLog(this, message);
    }

    @Override
    public void trace(Function0<Object> message) {
        Logging$class.trace(this, message);
    }

    @Override
    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.trace(this, message, e);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging$class.debug(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.debug(this, message, e);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging$class.info(this, message);
    }

    @Override
    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.info(this, message, e);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging$class.warn(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.warn(this, message, e);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging$class.error(this, message);
    }

    @Override
    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.error(this, message, e);
    }

    @Override
    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging$class.putMDC(this, key, value);
    }

    @Override
    public String getMDC(Function0<String> key) {
        return Logging$class.getMDC(this, key);
    }

    @Override
    public void removeMDC(Function0<String> key) {
        Logging$class.removeMDC(this, key);
    }

    @Override
    public void clearMDC() {
        Logging$class.clearMDC(this);
    }

    public void start() {
        this.debug((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting producers.";
            }
        });
        this.org$apache$samza$system$SystemProducers$$producers.values().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(SystemProducer x$1) {
                x$1.start();
            }
        });
    }

    public void stop() {
        this.debug((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopping producers.";
            }
        });
        this.org$apache$samza$system$SystemProducers$$producers.values().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(SystemProducer x$2) {
                x$2.stop();
            }
        });
    }

    public void register(String source) {
        this.debug((Function0<Object>)new Serializable(this, source){
            public static final long serialVersionUID = 0L;
            private final String source$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Registering source: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.source$1}));
            }
            {
                this.source$1 = source$1;
            }
        });
        this.metrics.registerSource(source);
        this.org$apache$samza$system$SystemProducers$$producers.values().foreach((Function1)new Serializable(this, source){
            public static final long serialVersionUID = 0L;
            private final String source$1;

            public final void apply(SystemProducer x$3) {
                x$3.register(this.source$1);
            }
            {
                this.source$1 = source$1;
            }
        });
    }

    public void flush(String source) {
        this.debug((Function0<Object>)new Serializable(this, source){
            public static final long serialVersionUID = 0L;
            private final String source$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Flushing source: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.source$2}));
            }
            {
                this.source$2 = source$2;
            }
        });
        this.metrics.flushes().inc();
        ((Counter)this.metrics.sourceFlushes().apply((Object)source)).inc();
        this.org$apache$samza$system$SystemProducers$$producers.values().foreach((Function1)new Serializable(this, source){
            public static final long serialVersionUID = 0L;
            private final String source$2;

            public final void apply(SystemProducer x$4) {
                x$4.flush(this.source$2);
            }
            {
                this.source$2 = source$2;
            }
        });
    }

    public void send(String source, OutgoingMessageEnvelope envelope) {
        Throwable throwable2;
        block5: {
            Some bytesEnvelope;
            Some some;
            this.trace((Function0<Object>)new Serializable(this, source, envelope){
                public static final long serialVersionUID = 0L;
                private final String source$3;
                private final OutgoingMessageEnvelope envelope$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Sending message from source: %s, %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.envelope$1, this.source$3}));
                }
                {
                    this.source$3 = source$3;
                    this.envelope$1 = envelope$1;
                }
            });
            this.metrics.sends().inc();
            ((Counter)this.metrics.sourceSends().apply((Object)source)).inc();
            try {
                some = new Some((Object)this.serdeManager.toBytes(envelope));
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                if (throwable3 != null) {
                    Throwable throwable4 = throwable3;
                    if (!this.dropSerializationError) {
                        throw new SamzaException("can not serialize the message", throwable4);
                    }
                }
                if (throwable3 == null) break block5;
                Throwable throwable5 = throwable3;
                this.debug((Function0<Object>)new Serializable(this, throwable5){
                    public static final long serialVersionUID = 0L;
                    private final Throwable x8$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Serialization fails: %s . Drop the error message")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x8$1}));
                    }
                    {
                        this.x8$1 = x8$1;
                    }
                });
                this.metrics.serializationError().inc();
                None$ none$ = None$.MODULE$;
                some = bytesEnvelope = none$;
            }
            if (!bytesEnvelope.isEmpty()) {
                String system = envelope.getSystemStream().getSystem();
                SystemProducer producer = (SystemProducer)this.org$apache$samza$system$SystemProducers$$producers.getOrElse((Object)system, (Function0)new Serializable(this, system){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ SystemProducers $outer;
                    private final String system$1;

                    public final Nothing$ apply() {
                        throw new SamzaException(new StringOps(Predef$.MODULE$.augmentString("Attempting to produce to unknown system: %s. Available systems: %s. Please add the system to your configuration, or update outgoing message envelope to send to a defined system.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.system$1, this.$outer.org$apache$samza$system$SystemProducers$$producers.keySet()})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.system$1 = system$1;
                    }
                });
                producer.send(source, (OutgoingMessageEnvelope)bytesEnvelope.get());
            }
            return;
        }
        throw throwable2;
    }

    public SystemProducers(Map<String, SystemProducer> producers, SerdeManager serdeManager, SystemProducersMetrics metrics, boolean dropSerializationError) {
        this.org$apache$samza$system$SystemProducers$$producers = producers;
        this.serdeManager = serdeManager;
        this.metrics = metrics;
        this.dropSerializationError = dropSerializationError;
        Logging$class.$init$(this);
    }
}

