/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system;

import java.util.Map;
import java.util.Set;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.JavaSystemConfig;
import org.apache.samza.config.MapConfig;
import org.apache.samza.system.SystemAdmin;

public class SystemAdmins {
    private final Map<String, SystemAdmin> systemAdminMap;

    public SystemAdmins(Config config) {
        JavaSystemConfig systemConfig = new JavaSystemConfig(config);
        this.systemAdminMap = systemConfig.getSystemAdmins();
    }

    public static SystemAdmins empty() {
        return new SystemAdmins((Config)new MapConfig());
    }

    public void start() {
        for (SystemAdmin systemAdmin : this.systemAdminMap.values()) {
            systemAdmin.start();
        }
    }

    public void stop() {
        for (SystemAdmin systemAdmin : this.systemAdminMap.values()) {
            systemAdmin.stop();
        }
    }

    public SystemAdmin getSystemAdmin(String systemName) {
        if (!this.systemAdminMap.containsKey(systemName)) {
            throw new SamzaException("Cannot get systemAdmin for system " + systemName);
        }
        return this.systemAdminMap.get(systemName);
    }

    public Set<String> getSystemNames() {
        return this.systemAdminMap.keySet();
    }
}

