/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system;

import java.time.Duration;
import java.time.Instant;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.samza.system.SystemAdmin;
import org.apache.samza.system.SystemAdmins;
import org.apache.samza.system.SystemStreamMetadata;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.util.Clock;

public class SSPMetadataCache {
    private final SystemAdmins systemAdmins;
    private final Duration cacheTTL;
    private final Clock clock;
    private final Set<SystemStreamPartition> sspsToPrefetch;
    private final Object metadataRefreshLock;
    private final ConcurrentHashMap<SystemStreamPartition, CacheEntry> cache;

    public SSPMetadataCache(SystemAdmins systemAdmins, Duration cacheTTL, Clock clock, Set<SystemStreamPartition> sspsToPrefetch) {
        this.systemAdmins = systemAdmins;
        this.cacheTTL = cacheTTL;
        this.clock = clock;
        this.sspsToPrefetch = sspsToPrefetch;
        this.metadataRefreshLock = new Object();
        this.cache = new ConcurrentHashMap();
    }

    public SystemStreamMetadata.SystemStreamPartitionMetadata getMetadata(SystemStreamPartition ssp) {
        this.maybeRefreshMetadata(ssp);
        CacheEntry cacheEntry = this.cache.get(ssp);
        return cacheEntry == null ? null : cacheEntry.getMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeRefreshMetadata(SystemStreamPartition requestedSSP) {
        Object object = this.metadataRefreshLock;
        synchronized (object) {
            Instant refreshRequestedAt = Instant.ofEpochMilli(this.clock.currentTimeMillis());
            if (this.shouldRefresh(requestedSSP, refreshRequestedAt)) {
                String system = requestedSSP.getSystem();
                HashSet<SystemStreamPartition> sspsToFetchFor = new HashSet<SystemStreamPartition>();
                sspsToFetchFor.add(requestedSSP);
                for (SystemStreamPartition sspToPrefetch : this.sspsToPrefetch) {
                    if (!system.equals(sspToPrefetch.getSystem()) || !this.shouldRefresh(sspToPrefetch, refreshRequestedAt)) continue;
                    sspsToFetchFor.add(sspToPrefetch);
                }
                SystemAdmin systemAdmin = this.systemAdmins.getSystemAdmin(system);
                Map fetchedMetadata = systemAdmin.getSSPMetadata(sspsToFetchFor);
                Instant updatedAt = Instant.ofEpochMilli(this.clock.currentTimeMillis());
                sspsToFetchFor.forEach(ssp -> this.cache.put((SystemStreamPartition)ssp, new CacheEntry((SystemStreamMetadata.SystemStreamPartitionMetadata)fetchedMetadata.get(ssp), updatedAt)));
            }
        }
    }

    private boolean shouldRefresh(SystemStreamPartition ssp, Instant now) {
        CacheEntry cacheEntry = this.cache.get(ssp);
        if (cacheEntry == null) {
            return true;
        }
        Instant isFreshUntil = cacheEntry.getLastUpdatedAt().plus(this.cacheTTL);
        return now.isAfter(isFreshUntil);
    }

    private static class CacheEntry {
        private final SystemStreamMetadata.SystemStreamPartitionMetadata metadata;
        private final Instant lastUpdatedAt;

        private CacheEntry(SystemStreamMetadata.SystemStreamPartitionMetadata metadata, Instant lastUpdatedAt) {
            this.metadata = metadata;
            this.lastUpdatedAt = lastUpdatedAt;
        }

        private SystemStreamMetadata.SystemStreamPartitionMetadata getMetadata() {
            return this.metadata;
        }

        private Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }
    }
}

