/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.storage;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.samza.Partition;
import org.apache.samza.SamzaException;
import org.apache.samza.config.StorageConfig$;
import org.apache.samza.container.TaskName;
import org.apache.samza.storage.StorageEngine;
import org.apache.samza.storage.StorageManagerUtil;
import org.apache.samza.storage.TaskStorageManager$;
import org.apache.samza.system.SSPMetadataCache;
import org.apache.samza.system.StreamMetadataCache;
import org.apache.samza.system.StreamSpec;
import org.apache.samza.system.SystemAdmin;
import org.apache.samza.system.SystemAdmins;
import org.apache.samza.system.SystemConsumer;
import org.apache.samza.system.SystemStream;
import org.apache.samza.system.SystemStreamMetadata;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.system.SystemStreamPartitionIterator;
import org.apache.samza.util.Clock;
import org.apache.samza.util.FileUtil$;
import org.apache.samza.util.Logging;
import org.apache.samza.util.Logging$class;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\t%s!B\u0001\u0003\u0011\u0003Y\u0011A\u0005+bg.\u001cFo\u001c:bO\u0016l\u0015M\\1hKJT!a\u0001\u0003\u0002\u000fM$xN]1hK*\u0011QAB\u0001\u0006g\u0006l'0\u0019\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0011\u00051iQ\"\u0001\u0002\u0007\u000b9\u0011\u0001\u0012A\b\u0003%Q\u000b7o[*u_J\fw-Z'b]\u0006<WM]\n\u0003\u001bA\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007\"B\f\u000e\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\f\u0011\u0015QR\u0002\"\u0001\u001c\u0003-9W\r^*u_J,G)\u001b:\u0015\u0007q!c\u0005\u0005\u0002\u001eE5\taD\u0003\u0002 A\u0005\u0011\u0011n\u001c\u0006\u0002C\u0005!!.\u0019<b\u0013\t\u0019cD\u0001\u0003GS2,\u0007\"B\u0013\u001a\u0001\u0004a\u0012\u0001D:u_J,')Y:f\t&\u0014\b\"B\u0014\u001a\u0001\u0004A\u0013!C:u_J,g*Y7f!\tICF\u0004\u0002\u0012U%\u00111FE\u0001\u0007!J,G-\u001a4\n\u00055r#AB*ue&twM\u0003\u0002,%!)\u0001'\u0004C\u0001c\u0005!r-\u001a;Ti>\u0014X\rU1si&$\u0018n\u001c8ESJ$B\u0001\b\u001a4i!)Qe\fa\u00019!)qe\fa\u0001Q!)Qg\fa\u0001m\u0005AA/Y:l\u001d\u0006lW\r\u0005\u00028u5\t\u0001H\u0003\u0002:\t\u0005I1m\u001c8uC&tWM]\u0005\u0003wa\u0012\u0001\u0002V1tW:\u000bW.\u001a\u0005\b{5\t\n\u0011\"\u0001?\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\tqH\u000b\u0002A\rB!\u0011&\u0011\u0015D\u0013\t\u0011eFA\u0002NCB\u0004\"\u0001\u0004#\n\u0005\u0015\u0013!!D*u_J\fw-Z#oO&tWmK\u0001H!\tAU*D\u0001J\u0015\tQ5*A\u0005v]\u000eDWmY6fI*\u0011AJE\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001(J\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\b!6\t\n\u0011\"\u0001R\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\t!K\u000b\u0002T\rB!\u0011&\u0011\u0015U!\t)\u0006,D\u0001W\u0015\t9F!\u0001\u0004tsN$X-\\\u0005\u00033Z\u0013abU=ti\u0016l7i\u001c8tk6,'\u000fC\u0004\\\u001bE\u0005I\u0011\u0001/\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\u0005i&F\u00010G!\u0011I\u0013\tK0\u0011\u0005U\u0003\u0017BA1W\u00051\u0019\u0016p\u001d;f[N#(/Z1n\u0011\u001d\u0019W\"%A\u0005\u0002\u0011\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012BT#A3+\u0005q1\u0005bB4\u000e#\u0003%\t\u0001Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001d\u0007\t9\u0011\u0001![\n\u0004QBQ\u0007CA6o\u001b\u0005a'BA7\u0005\u0003\u0011)H/\u001b7\n\u0005=d'a\u0002'pO\u001eLgn\u001a\u0005\tk!\u0014\t\u0011)A\u0005m!A!\u000f\u001bB\u0001B\u0003%\u0001)\u0001\u0006uCN\\7\u000b^8sKND\u0001\u0002\u001e5\u0003\u0002\u0003\u0006IaU\u0001\u000fgR|'/Z\"p]N,X.\u001a:t\u0011!1\bN!A!\u0002\u0013q\u0016AF2iC:<W\rT8h'f\u001cH/Z7TiJ,\u0017-\\:\t\u0011aD'\u0011!Q\u0001\ne\f\u0011d\u00195b]\u001e,Gj\\4TiJ,\u0017-\u001c)beRLG/[8ogB\u0011\u0011C_\u0005\u0003wJ\u00111!\u00138u\u0011!i\bN!A!\u0002\u0013q\u0018aE:ue\u0016\fW.T3uC\u0012\fG/Y\"bG\",\u0007CA+\u0000\u0013\r\t\tA\u0016\u0002\u0014'R\u0014X-Y7NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0005\u000b\u0003\u000bA'\u0011!Q\u0001\n\u0005\u001d\u0011\u0001E:ta6+G/\u00193bi\u0006\u001c\u0015m\u00195f!\r)\u0016\u0011B\u0005\u0004\u0003\u00171&\u0001E*T!6+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0011%\ty\u0001\u001bB\u0001B\u0003%A$A\u000bo_:dunZ4fIN#xN]3CCN,G)\u001b:\t\u0013\u0005M\u0001N!A!\u0002\u0013a\u0012A\u00057pO\u001e,Gm\u0015;pe\u0016\u0014\u0015m]3ESJD!\"a\u0006i\u0005\u0003\u0005\u000b\u0011BA\r\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u0003\u0002\u001c\u0005uQ\"\u0001\u0003\n\u0007\u0005}AAA\u0005QCJ$\u0018\u000e^5p]\"Q\u00111\u00055\u0003\u0002\u0003\u0006I!!\n\u0002\u0019ML8\u000f^3n\u0003\u0012l\u0017N\\:\u0011\u0007U\u000b9#C\u0002\u0002*Y\u0013AbU=ti\u0016l\u0017\tZ7j]ND!\"!\fi\u0005\u0003\u0005\u000b\u0011BA\u0018\u0003u\u0019\u0007.\u00198hK2{w\rR3mKR,'+\u001a;f]RLwN\\:J]6\u001b\b#B\u0015BQ\u0005E\u0002cA\t\u00024%\u0019\u0011Q\u0007\n\u0003\t1{gn\u001a\u0005\u000b\u0003sA'\u0011!Q\u0001\n\u0005m\u0012!B2m_\u000e\\\u0007cA6\u0002>%\u0019\u0011q\b7\u0003\u000b\rcwnY6\t\r]AG\u0011AA\")q\t)%a\u0012\u0002J\u0005-\u0013QJA(\u0003#\n\u0019&!\u0016\u0002X\u0005e\u00131LA/\u0003?\u0002\"\u0001\u00045\t\rU\n\t\u00051\u00017\u0011!\u0011\u0018\u0011\tI\u0001\u0002\u0004\u0001\u0005\u0002\u0003;\u0002BA\u0005\t\u0019A*\t\u0011Y\f\t\u0005%AA\u0002yCa\u0001_A!\u0001\u0004I\bBB?\u0002B\u0001\u0007a\u0010\u0003\u0005\u0002\u0006\u0005\u0005\u0003\u0019AA\u0004\u0011%\ty!!\u0011\u0011\u0002\u0003\u0007A\u0004C\u0005\u0002\u0014\u0005\u0005\u0003\u0013!a\u00019!A\u0011qCA!\u0001\u0004\tI\u0002\u0003\u0005\u0002$\u0005\u0005\u0003\u0019AA\u0013\u0011!\ti#!\u0011A\u0002\u0005=\u0002\u0002CA\u001d\u0003\u0003\u0002\r!a\u000f\t\u0013\u0005\r\u0004\u000e1A\u0005\u0002\u0005\u0015\u0014a\u0005;bg.\u001cFo\u001c:fgR{'+Z:u_J,WCAA4!\u0019\tI'a\u001d)\u00076\u0011\u00111\u000e\u0006\u0005\u0003[\ny'A\u0005j[6,H/\u00192mK*\u0019\u0011\u0011\u000f\n\u0002\u0015\r|G\u000e\\3di&|g.C\u0002C\u0003WB\u0011\"a\u001ei\u0001\u0004%\t!!\u001f\u0002/Q\f7o[*u_J,7\u000fV8SKN$xN]3`I\u0015\fH\u0003BA>\u0003\u0003\u00032!EA?\u0013\r\tyH\u0005\u0002\u0005+:LG\u000f\u0003\u0006\u0002\u0004\u0006U\u0014\u0011!a\u0001\u0003O\n1\u0001\u001f\u00132\u0011!\t9\t\u001bQ!\n\u0005\u001d\u0014\u0001\u0006;bg.\u001cFo\u001c:fgR{'+Z:u_J,\u0007\u0005C\u0005\u0002\f\"\u0014\r\u0011\"\u0001\u0002f\u0005y\u0001/\u001a:tSN$X\rZ*u_J,7\u000f\u0003\u0005\u0002\u0010\"\u0004\u000b\u0011BA4\u0003A\u0001XM]:jgR,Gm\u0015;pe\u0016\u001c\b\u0005C\u0005\u0002\u0014\"\u0004\r\u0011\"\u0001\u0002\u0016\u000612\r[1oO\u0016dunZ(mI\u0016\u001cHo\u00144gg\u0016$8/\u0006\u0002\u0002\u0018B!\u0011&Q0)\u0011%\tY\n\u001ba\u0001\n\u0003\ti*\u0001\u000edQ\u0006tw-\u001a'pO>cG-Z:u\u001f\u001a47/\u001a;t?\u0012*\u0017\u000f\u0006\u0003\u0002|\u0005}\u0005BCAB\u00033\u000b\t\u00111\u0001\u0002\u0018\"A\u00111\u00155!B\u0013\t9*A\fdQ\u0006tw-\u001a'pO>cG-Z:u\u001f\u001a47/\u001a;tA!I\u0011q\u00155C\u0002\u0013\u0005\u0011\u0011V\u0001\fM&dWm\u00144gg\u0016$8/\u0006\u0002\u0002,B9\u0011QVAY\u0003gCSBAAX\u0015\ti\u0007%C\u0002C\u0003_\u00032!VA[\u0013\r\t9L\u0016\u0002\u0016'f\u001cH/Z7TiJ,\u0017-\u001c)beRLG/[8o\u0011!\tY\f\u001bQ\u0001\n\u0005-\u0016\u0001\u00044jY\u0016|eMZ:fiN\u0004\u0003\"CA`Q\n\u0007I\u0011AAa\u00039ygMZ:fi\u001aKG.\u001a(b[\u0016,\"!a1\u0011\t\u0005\u0015\u00171Z\u0007\u0003\u0003\u000fT1!!3!\u0003\u0011a\u0017M\\4\n\u00075\n9\r\u0003\u0005\u0002P\"\u0004\u000b\u0011BAb\u0003=ygMZ:fi\u001aKG.\u001a(b[\u0016\u0004\u0003bBAjQ\u0012\u0005\u0011Q[\u0001\tO\u0016$8\u000b^8sKR!\u0011q[Ao!\u0011\t\u0012\u0011\\\"\n\u0007\u0005m'C\u0001\u0004PaRLwN\u001c\u0005\u0007O\u0005E\u0007\u0019\u0001\u0015\t\u000f\u0005\u0005\b\u000e\"\u0001\u0002d\u0006!\u0011N\\5u+\t\tY\bC\u0004\u0002h\"$I!!;\u0002\u001b\rdW-\u00198CCN,G)\u001b:t)\t\tY\bC\u0004\u0002n\"$I!a<\u0002%%\u001cHj\\4hK\u0012\u001cFo\u001c:f-\u0006d\u0017\u000e\u001a\u000b\u0007\u0003c\f90!?\u0011\u0007E\t\u00190C\u0002\u0002vJ\u0011qAQ8pY\u0016\fg\u000e\u0003\u0004(\u0003W\u0004\r\u0001\u000b\u0005\b\u0003w\fY\u000f1\u0001\u001d\u00039awnZ4fIN#xN]3ESJDq!a@i\t\u0013\tI/A\u0007tKR,\bOQ1tK\u0012K'o\u001d\u0005\b\u0005\u0007AG\u0011BAu\u0003a1\u0018\r\\5eCR,7\t[1oO\u0016dwnZ*ue\u0016\fWn\u001d\u0005\b\u0005\u000fAG\u0011BAu\u00039\u0019H/\u0019:u\u0007>t7/^7feNDqAa\u0003i\t\u0013\u0011i!A\thKR\u001cF/\u0019:uS:<wJ\u001a4tKR$b!a1\u0003\u0010\tM\u0001\u0002\u0003B\t\u0005\u0013\u0001\r!a-\u0002+ML8\u000f^3n'R\u0014X-Y7QCJ$\u0018\u000e^5p]\"A!Q\u0003B\u0005\u0001\u0004\u00119\"A\u0003bI6Lg\u000eE\u0002V\u00053I1Aa\u0007W\u0005-\u0019\u0016p\u001d;f[\u0006#W.\u001b8\t\u000f\t}\u0001\u000e\"\u0003\u0002j\u0006i!/Z:u_J,7\u000b^8sKNDqAa\ti\t\u0013\tI/A\u0007ti>\u00048i\u001c8tk6,'o\u001d\u0005\b\u0005OAG\u0011AAu\u0003\u00151G.^:i\u0011\u001d\u0011Y\u0003\u001bC\u0001\u0003S\f!b\u001d;paN#xN]3t\u0011\u001d\u0011y\u0003\u001bC\u0001\u0003S\fAa\u001d;pa\"9!1\u00075\u0005\n\u0005%\u0018!\u00074mkND7\t[1oO\u0016dwnZ(gMN,GOR5mKNDqAa\u000ei\t\u0013\u0011I$A\u0013hKR\u001c\u0005.\u00198hK2{wm\u00147eKN$xJ\u001a4tKR\u001chi\u001c:QCJ$\u0018\u000e^5p]R1\u0011q\u0013B\u001e\u0005{A\u0001\"a\u0006\u00036\u0001\u0007\u0011\u0011\u0004\u0005\t\u0005\u007f\u0011)\u00041\u0001\u0003B\u0005\u0019\u0012N\u001c9viN#(/Z1n\u001b\u0016$\u0018\rZ1uCB)\u0011&Q0\u0003DA\u0019QK!\u0012\n\u0007\t\u001dcK\u0001\u000bTsN$X-\\*ue\u0016\fW.T3uC\u0012\fG/\u0019")
public class TaskStorageManager
implements Logging {
    public final TaskName org$apache$samza$storage$TaskStorageManager$$taskName;
    private final scala.collection.immutable.Map<String, StorageEngine> taskStores;
    public final scala.collection.immutable.Map<String, SystemConsumer> org$apache$samza$storage$TaskStorageManager$$storeConsumers;
    public final scala.collection.immutable.Map<String, SystemStream> org$apache$samza$storage$TaskStorageManager$$changeLogSystemStreams;
    public final int org$apache$samza$storage$TaskStorageManager$$changeLogStreamPartitions;
    private final StreamMetadataCache streamMetadataCache;
    public final SSPMetadataCache org$apache$samza$storage$TaskStorageManager$$sspMetadataCache;
    public final File org$apache$samza$storage$TaskStorageManager$$nonLoggedStoreBaseDir;
    public final File org$apache$samza$storage$TaskStorageManager$$loggedStoreBaseDir;
    public final Partition org$apache$samza$storage$TaskStorageManager$$partition;
    public final SystemAdmins org$apache$samza$storage$TaskStorageManager$$systemAdmins;
    private final scala.collection.immutable.Map<String, Object> changeLogDeleteRetentionsInMs;
    private final Clock clock;
    private scala.collection.immutable.Map<String, StorageEngine> taskStoresToRestore;
    private final scala.collection.immutable.Map<String, StorageEngine> persistedStores;
    private scala.collection.immutable.Map<SystemStream, String> changeLogOldestOffsets;
    private final Map<SystemStreamPartition, String> fileOffsets;
    private final String offsetFileName;
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private volatile byte bitmap$0;

    public static File $lessinit$greater$default$9() {
        return TaskStorageManager$.MODULE$.$lessinit$greater$default$9();
    }

    public static File $lessinit$greater$default$8() {
        return TaskStorageManager$.MODULE$.$lessinit$greater$default$8();
    }

    public static scala.collection.immutable.Map<String, SystemStream> $lessinit$greater$default$4() {
        return TaskStorageManager$.MODULE$.$lessinit$greater$default$4();
    }

    public static scala.collection.immutable.Map<String, SystemConsumer> $lessinit$greater$default$3() {
        return TaskStorageManager$.MODULE$.$lessinit$greater$default$3();
    }

    public static scala.collection.immutable.Map<String, StorageEngine> $lessinit$greater$default$2() {
        return TaskStorageManager$.MODULE$.$lessinit$greater$default$2();
    }

    public static File getStorePartitionDir(File file, String string, TaskName taskName) {
        return TaskStorageManager$.MODULE$.getStorePartitionDir(file, string, taskName);
    }

    public static File getStoreDir(File file, String string) {
        return TaskStorageManager$.MODULE$.getStoreDir(file, string);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        TaskStorageManager taskStorageManager = this;
        synchronized (taskStorageManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        TaskStorageManager taskStorageManager = this;
        synchronized (taskStorageManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging$class.startupLogger(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    @Override
    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    @Override
    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    @Override
    public void startupLog(Function0<Object> message) {
        Logging$class.startupLog(this, message);
    }

    @Override
    public void trace(Function0<Object> message) {
        Logging$class.trace(this, message);
    }

    @Override
    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.trace(this, message, e);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging$class.debug(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.debug(this, message, e);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging$class.info(this, message);
    }

    @Override
    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.info(this, message, e);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging$class.warn(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.warn(this, message, e);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging$class.error(this, message);
    }

    @Override
    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.error(this, message, e);
    }

    @Override
    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging$class.putMDC(this, key, value);
    }

    @Override
    public String getMDC(Function0<String> key) {
        return Logging$class.getMDC(this, key);
    }

    @Override
    public void removeMDC(Function0<String> key) {
        Logging$class.removeMDC(this, key);
    }

    @Override
    public void clearMDC() {
        Logging$class.clearMDC(this);
    }

    public scala.collection.immutable.Map<String, StorageEngine> taskStoresToRestore() {
        return this.taskStoresToRestore;
    }

    public void taskStoresToRestore_$eq(scala.collection.immutable.Map<String, StorageEngine> x$1) {
        this.taskStoresToRestore = x$1;
    }

    public scala.collection.immutable.Map<String, StorageEngine> persistedStores() {
        return this.persistedStores;
    }

    public scala.collection.immutable.Map<SystemStream, String> changeLogOldestOffsets() {
        return this.changeLogOldestOffsets;
    }

    public void changeLogOldestOffsets_$eq(scala.collection.immutable.Map<SystemStream, String> x$1) {
        this.changeLogOldestOffsets = x$1;
    }

    public Map<SystemStreamPartition, String> fileOffsets() {
        return this.fileOffsets;
    }

    public String offsetFileName() {
        return this.offsetFileName;
    }

    public Option<StorageEngine> getStore(String storeName) {
        return this.taskStores.get((Object)storeName);
    }

    public void init() {
        this.cleanBaseDirs();
        this.setupBaseDirs();
        this.validateChangelogStreams();
        this.startConsumers();
        this.restoreStores();
        this.stopConsumers();
    }

    private void cleanBaseDirs() {
        this.debug((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Cleaning base directories for stores.";
            }
        });
        this.taskStores.keys().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TaskStorageManager $outer;

            public final Object apply(String storeName) {
                Object object;
                File nonLoggedStorePartitionDir = TaskStorageManager$.MODULE$.getStorePartitionDir(this.$outer.org$apache$samza$storage$TaskStorageManager$$nonLoggedStoreBaseDir, storeName, this.$outer.org$apache$samza$storage$TaskStorageManager$$taskName);
                this.$outer.info((Function0<Object>)new Serializable(this, nonLoggedStorePartitionDir){
                    public static final long serialVersionUID = 0L;
                    private final File nonLoggedStorePartitionDir$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Got non logged storage partition directory as %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Object)this.nonLoggedStorePartitionDir$1.toPath()).toString()}));
                    }
                    {
                        this.nonLoggedStorePartitionDir$1 = nonLoggedStorePartitionDir$1;
                    }
                });
                if (nonLoggedStorePartitionDir.exists()) {
                    this.$outer.info((Function0<Object>)new Serializable(this, nonLoggedStorePartitionDir){
                        public static final long serialVersionUID = 0L;
                        private final File nonLoggedStorePartitionDir$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Deleting non logged storage partition directory %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Object)this.nonLoggedStorePartitionDir$1.toPath()).toString()}));
                        }
                        {
                            this.nonLoggedStorePartitionDir$1 = nonLoggedStorePartitionDir$1;
                        }
                    });
                    FileUtil$.MODULE$.rm(nonLoggedStorePartitionDir);
                }
                File loggedStorePartitionDir = TaskStorageManager$.MODULE$.getStorePartitionDir(this.$outer.org$apache$samza$storage$TaskStorageManager$$loggedStoreBaseDir, storeName, this.$outer.org$apache$samza$storage$TaskStorageManager$$taskName);
                this.$outer.info((Function0<Object>)new Serializable(this, loggedStorePartitionDir){
                    public static final long serialVersionUID = 0L;
                    private final File loggedStorePartitionDir$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Got logged storage partition directory as %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Object)this.loggedStorePartitionDir$1.toPath()).toString()}));
                    }
                    {
                        this.loggedStorePartitionDir$1 = loggedStorePartitionDir$1;
                    }
                });
                if (this.$outer.org$apache$samza$storage$TaskStorageManager$$isLoggedStoreValid(storeName, loggedStorePartitionDir)) {
                    String offset = StorageManagerUtil.readOffsetFile(loggedStorePartitionDir, this.$outer.offsetFileName());
                    this.$outer.info((Function0<Object>)new Serializable(this, loggedStorePartitionDir, offset, storeName){
                        public static final long serialVersionUID = 0L;
                        private final File loggedStorePartitionDir$1;
                        private final String offset$1;
                        private final String storeName$3;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Read offset %s for the store %s from logged storage partition directory %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.offset$1, this.storeName$3, this.loggedStorePartitionDir$1}));
                        }
                        {
                            this.loggedStorePartitionDir$1 = loggedStorePartitionDir$1;
                            this.offset$1 = offset$1;
                            this.storeName$3 = storeName$3;
                        }
                    });
                    object = offset == null ? BoxedUnit.UNIT : this.$outer.fileOffsets().put(new SystemStreamPartition((SystemStream)this.$outer.org$apache$samza$storage$TaskStorageManager$$changeLogSystemStreams.apply((Object)storeName), this.$outer.org$apache$samza$storage$TaskStorageManager$$partition), offset);
                } else {
                    this.$outer.info((Function0<Object>)new Serializable(this, loggedStorePartitionDir){
                        public static final long serialVersionUID = 0L;
                        private final File loggedStorePartitionDir$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Deleting logged storage partition directory %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Object)this.loggedStorePartitionDir$1.toPath()).toString()}));
                        }
                        {
                            this.loggedStorePartitionDir$1 = loggedStorePartitionDir$1;
                        }
                    });
                    FileUtil$.MODULE$.rm(loggedStorePartitionDir);
                    object = BoxedUnit.UNIT;
                }
                return object;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public boolean org$apache$samza$storage$TaskStorageManager$$isLoggedStoreValid(String storeName, File loggedStoreDir) {
        long changeLogDeleteRetentionInMs = BoxesRunTime.unboxToLong((Object)this.changeLogDeleteRetentionsInMs.getOrElse((Object)storeName, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return StorageConfig$.MODULE$.DEFAULT_CHANGELOG_DELETE_RETENTION_MS();
            }
        }));
        return this.persistedStores().contains((Object)storeName) && StorageManagerUtil.isOffsetFileValid(loggedStoreDir, this.offsetFileName()) && !StorageManagerUtil.isStaleStore(loggedStoreDir, this.offsetFileName(), changeLogDeleteRetentionInMs, this.clock.currentTimeMillis());
    }

    private void setupBaseDirs() {
        this.debug((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Setting up base directories for stores.";
            }
        });
        this.taskStores.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TaskStorageManager $outer;

            public final Object apply(Tuple2<String, StorageEngine> x0$3) {
                Tuple2<String, StorageEngine> tuple2 = x0$3;
                if (tuple2 != null) {
                    Boolean bl;
                    String storeName = (String)tuple2._1();
                    StorageEngine storageEngine = (StorageEngine)tuple2._2();
                    if (storageEngine.getStoreProperties().isLoggedStore()) {
                        File loggedStorePartitionDir = TaskStorageManager$.MODULE$.getStorePartitionDir(this.$outer.org$apache$samza$storage$TaskStorageManager$$loggedStoreBaseDir, storeName, this.$outer.org$apache$samza$storage$TaskStorageManager$$taskName);
                        this.$outer.info((Function0<Object>)new Serializable(this, storeName, loggedStorePartitionDir){
                            public static final long serialVersionUID = 0L;
                            private final String storeName$1;
                            private final File loggedStorePartitionDir$2;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Using logged storage partition directory: %s for store: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Object)this.loggedStorePartitionDir$2.toPath()).toString(), this.storeName$1}));
                            }
                            {
                                this.storeName$1 = storeName$1;
                                this.loggedStorePartitionDir$2 = loggedStorePartitionDir$2;
                            }
                        });
                        bl = loggedStorePartitionDir.exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)loggedStorePartitionDir.mkdirs());
                    } else {
                        File nonLoggedStorePartitionDir = TaskStorageManager$.MODULE$.getStorePartitionDir(this.$outer.org$apache$samza$storage$TaskStorageManager$$nonLoggedStoreBaseDir, storeName, this.$outer.org$apache$samza$storage$TaskStorageManager$$taskName);
                        this.$outer.info((Function0<Object>)new Serializable(this, storeName, nonLoggedStorePartitionDir){
                            public static final long serialVersionUID = 0L;
                            private final String storeName$1;
                            private final File nonLoggedStorePartitionDir$2;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Using non logged storage partition directory: %s for store: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Object)this.nonLoggedStorePartitionDir$2.toPath()).toString(), this.storeName$1}));
                            }
                            {
                                this.storeName$1 = storeName$1;
                                this.nonLoggedStorePartitionDir$2 = nonLoggedStorePartitionDir$2;
                            }
                        });
                        bl = BoxesRunTime.boxToBoolean((boolean)nonLoggedStorePartitionDir.mkdirs());
                    }
                    Boolean bl2 = bl;
                    return bl2;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private void validateChangelogStreams() {
        this.info((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TaskStorageManager $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Validating change log streams: ").append(this.$outer.org$apache$samza$storage$TaskStorageManager$$changeLogSystemStreams).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.org$apache$samza$storage$TaskStorageManager$$changeLogSystemStreams.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, SystemStream> check$ifrefutable$1) {
                Tuple2<String, SystemStream> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TaskStorageManager $outer;

            public final void apply(Tuple2<String, SystemStream> x$1) {
                Tuple2<String, SystemStream> tuple2 = x$1;
                if (tuple2 != null) {
                    SystemStream systemStream = (SystemStream)tuple2._2();
                    SystemAdmin systemAdmin = this.$outer.org$apache$samza$storage$TaskStorageManager$$systemAdmins.getSystemAdmin(systemStream.getSystem());
                    StreamSpec changelogSpec = StreamSpec.createChangeLogStreamSpec((String)systemStream.getStream(), (String)systemStream.getSystem(), (int)this.$outer.org$apache$samza$storage$TaskStorageManager$$changeLogStreamPartitions);
                    systemAdmin.validateStream(changelogSpec);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        scala.collection.immutable.Map<SystemStream, SystemStreamMetadata> changeLogMetadata = this.streamMetadataCache.getStreamMetadata((Set<SystemStream>)this.org$apache$samza$storage$TaskStorageManager$$changeLogSystemStreams.values().toSet(), this.streamMetadataCache.getStreamMetadata$default$2());
        this.info((Function0<Object>)new Serializable(this, changeLogMetadata){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map changeLogMetadata$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got change log stream metadata: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.changeLogMetadata$1}));
            }
            {
                this.changeLogMetadata$1 = changeLogMetadata$1;
            }
        });
        this.changeLogOldestOffsets_$eq(this.getChangeLogOldestOffsetsForPartition(this.org$apache$samza$storage$TaskStorageManager$$partition, changeLogMetadata));
        this.info((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TaskStorageManager $outer;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Assigning oldest change log offsets for taskName %s: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$samza$storage$TaskStorageManager$$taskName, this.$outer.changeLogOldestOffsets()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private void startConsumers() {
        this.debug((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting consumers for stores.";
            }
        });
        this.org$apache$samza$storage$TaskStorageManager$$changeLogSystemStreams.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, SystemStream> check$ifrefutable$2) {
                Tuple2<String, SystemStream> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TaskStorageManager $outer;

            public final void apply(Tuple2<String, SystemStream> x$2) {
                Tuple2<String, SystemStream> tuple2 = x$2;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    String storeName = (String)tuple2._1();
                    SystemStream systemStream = (SystemStream)tuple2._2();
                    SystemStreamPartition systemStreamPartition = new SystemStreamPartition(systemStream, this.$outer.org$apache$samza$storage$TaskStorageManager$$partition);
                    SystemAdmin admin = this.$outer.org$apache$samza$storage$TaskStorageManager$$systemAdmins.getSystemAdmin(systemStream.getSystem());
                    SystemConsumer consumer = (SystemConsumer)this.$outer.org$apache$samza$storage$TaskStorageManager$$storeConsumers.apply((Object)storeName);
                    String offset = this.$outer.org$apache$samza$storage$TaskStorageManager$$getStartingOffset(systemStreamPartition, admin);
                    if (offset == null) {
                        this.$outer.info((Function0<Object>)new Serializable(this, systemStreamPartition){
                            public static final long serialVersionUID = 0L;
                            private final SystemStreamPartition systemStreamPartition$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Skipping change log restoration for %s because stream appears to be empty (offset was null).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.systemStreamPartition$1}));
                            }
                            {
                                this.systemStreamPartition$1 = systemStreamPartition$1;
                            }
                        });
                        this.$outer.taskStoresToRestore_$eq((scala.collection.immutable.Map<String, StorageEngine>)((scala.collection.immutable.Map)this.$outer.taskStoresToRestore().$minus((Object)storeName)));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.$outer.info((Function0<Object>)new Serializable(this, systemStreamPartition, offset){
                            public static final long serialVersionUID = 0L;
                            private final SystemStreamPartition systemStreamPartition$1;
                            private final String offset$2;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Registering change log consumer with offset %s for %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.offset$2, this.systemStreamPartition$1}));
                            }
                            {
                                this.systemStreamPartition$1 = systemStreamPartition$1;
                                this.offset$2 = offset$2;
                            }
                        });
                        consumer.register(systemStreamPartition, offset);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.org$apache$samza$storage$TaskStorageManager$$storeConsumers.values().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(SystemConsumer x$3) {
                x$3.start();
            }
        });
    }

    public String org$apache$samza$storage$TaskStorageManager$$getStartingOffset(SystemStreamPartition systemStreamPartition, SystemAdmin admin) {
        String fileOffset = this.fileOffsets().get(systemStreamPartition);
        String oldestOffset = (String)this.changeLogOldestOffsets().getOrElse((Object)systemStreamPartition.getSystemStream(), (Function0)new Serializable(this, systemStreamPartition){
            public static final long serialVersionUID = 0L;
            private final SystemStreamPartition systemStreamPartition$2;

            public final Nothing$ apply() {
                throw new SamzaException(new StringOps(Predef$.MODULE$.augmentString("Missing a change log offset for %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.systemStreamPartition$2})));
            }
            {
                this.systemStreamPartition$2 = systemStreamPartition$2;
            }
        });
        return StorageManagerUtil.getStartingOffset(systemStreamPartition, admin, fileOffset, oldestOffset);
    }

    private void restoreStores() {
        this.debug((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TaskStorageManager $outer;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Restoring stores for task: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$samza$storage$TaskStorageManager$$taskName.getTaskName()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.taskStoresToRestore().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, StorageEngine> check$ifrefutable$3) {
                Tuple2<String, StorageEngine> tuple2 = check$ifrefutable$3;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TaskStorageManager $outer;

            public final void apply(Tuple2<String, StorageEngine> x$4) {
                Tuple2<String, StorageEngine> tuple2 = x$4;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    String storeName = (String)tuple2._1();
                    StorageEngine store = (StorageEngine)tuple2._2();
                    if (this.$outer.org$apache$samza$storage$TaskStorageManager$$changeLogSystemStreams.contains((Object)storeName)) {
                        SystemStream systemStream = (SystemStream)this.$outer.org$apache$samza$storage$TaskStorageManager$$changeLogSystemStreams.apply((Object)storeName);
                        SystemStreamPartition systemStreamPartition = new SystemStreamPartition(systemStream, this.$outer.org$apache$samza$storage$TaskStorageManager$$partition);
                        SystemConsumer systemConsumer = (SystemConsumer)this.$outer.org$apache$samza$storage$TaskStorageManager$$storeConsumers.apply((Object)storeName);
                        SystemStreamPartitionIterator systemConsumerIterator = new SystemStreamPartitionIterator(systemConsumer, systemStreamPartition);
                        store.restore((Iterator)systemConsumerIterator);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private void stopConsumers() {
        this.debug((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopping consumers for stores.";
            }
        });
        this.org$apache$samza$storage$TaskStorageManager$$storeConsumers.values().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(SystemConsumer x$5) {
                x$5.stop();
            }
        });
    }

    public void flush() {
        this.debug((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Flushing stores.";
            }
        });
        this.taskStores.values().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(StorageEngine x$6) {
                x$6.flush();
            }
        });
        this.flushChangelogOffsetFiles();
    }

    public void stopStores() {
        this.debug((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopping stores.";
            }
        });
        this.taskStores.values().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(StorageEngine x$7) {
                x$7.stop();
            }
        });
    }

    public void stop() {
        this.stopStores();
        this.flushChangelogOffsetFiles();
    }

    private void flushChangelogOffsetFiles() {
        this.debug((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Persisting logged key value stores";
            }
        });
        this.org$apache$samza$storage$TaskStorageManager$$changeLogSystemStreams.filterKeys((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TaskStorageManager $outer;

            public final boolean apply(String storeName) {
                return this.$outer.persistedStores().contains((Object)storeName);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, SystemStream> check$ifrefutable$4) {
                Tuple2<String, SystemStream> tuple2 = check$ifrefutable$4;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TaskStorageManager $outer;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void apply(Tuple2<String, SystemStream> x$8) {
                BoxedUnit boxedUnit;
                Tuple2<String, SystemStream> tuple2 = x$8;
                if (tuple2 == null) throw new MatchError(tuple2);
                String storeName = (String)tuple2._1();
                SystemStream systemStream = (SystemStream)tuple2._2();
                this.$outer.debug((Function0<Object>)new Serializable(this, storeName){
                    public static final long serialVersionUID = 0L;
                    private final String storeName$2;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Fetching newest offset for store %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.storeName$2}));
                    }
                    {
                        this.storeName$2 = storeName$2;
                    }
                });
                try {
                    SystemStreamPartition ssp = new SystemStreamPartition(systemStream.getSystem(), systemStream.getStream(), this.$outer.org$apache$samza$storage$TaskStorageManager$$partition);
                    SystemStreamMetadata.SystemStreamPartitionMetadata sspMetadata = this.$outer.org$apache$samza$storage$TaskStorageManager$$sspMetadataCache.getMetadata(ssp);
                    String newestOffset = sspMetadata == null ? null : sspMetadata.getNewestOffset();
                    this.$outer.debug((Function0<Object>)new Serializable(this, storeName, newestOffset){
                        public static final long serialVersionUID = 0L;
                        private final String storeName$2;
                        private final String newestOffset$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Got offset %s for store %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newestOffset$1, this.storeName$2}));
                        }
                        {
                            this.storeName$2 = storeName$2;
                            this.newestOffset$1 = newestOffset$1;
                        }
                    });
                    File loggedStorePartitionDir = TaskStorageManager$.MODULE$.getStorePartitionDir(this.$outer.org$apache$samza$storage$TaskStorageManager$$loggedStoreBaseDir, storeName, this.$outer.org$apache$samza$storage$TaskStorageManager$$taskName);
                    File offsetFile = new File(loggedStorePartitionDir, this.$outer.offsetFileName());
                    if (newestOffset == null) {
                        if (offsetFile.exists()) {
                            FileUtil$.MODULE$.rm(offsetFile);
                        }
                        this.$outer.debug((Function0<Object>)new Serializable(this, storeName, systemStream){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$flushChangelogOffsetFiles$4 $outer;
                            private final String storeName$2;
                            private final SystemStream systemStream$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Not storing OFFSET file for taskName %s. Store %s backed by changelog topic: %s, partition: %s is empty. ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$samza$storage$TaskStorageManager$$anonfun$$$outer().org$apache$samza$storage$TaskStorageManager$$taskName, this.storeName$2, this.systemStream$1.getStream(), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$samza$storage$TaskStorageManager$$anonfun$$$outer().org$apache$samza$storage$TaskStorageManager$$partition.getPartitionId())}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.storeName$2 = storeName$2;
                                this.systemStream$1 = systemStream$1;
                            }
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.$outer.debug((Function0<Object>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Storing offset for store in OFFSET file ";
                            }
                        });
                        FileUtil$.MODULE$.writeWithChecksum(offsetFile, newestOffset);
                        this.$outer.debug((Function0<Object>)new Serializable(this, storeName, newestOffset){
                            public static final long serialVersionUID = 0L;
                            private final String storeName$2;
                            private final String newestOffset$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Successfully stored offset %s for store %s in OFFSET file ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newestOffset$1, this.storeName$2}));
                            }
                            {
                                this.storeName$2 = storeName$2;
                                this.newestOffset$1 = newestOffset$1;
                            }
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
                catch (Exception exception) {
                    this.$outer.error((Function0<Object>)new Serializable(this, storeName){
                        public static final long serialVersionUID = 0L;
                        private final String storeName$2;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Exception storing offset for store %s. Skipping.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.storeName$2}));
                        }
                        {
                            this.storeName$2 = storeName$2;
                        }
                    }, (Function0<Throwable>)new Serializable(this, exception){
                        public static final long serialVersionUID = 0L;
                        private final Exception e$1;

                        public final Exception apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = e$1;
                        }
                    });
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }

            public /* synthetic */ TaskStorageManager org$apache$samza$storage$TaskStorageManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.debug((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Done persisting logged key value stores";
            }
        });
    }

    private scala.collection.immutable.Map<SystemStream, String> getChangeLogOldestOffsetsForPartition(Partition partition, scala.collection.immutable.Map<SystemStream, SystemStreamMetadata> inputStreamMetadata) {
        return ((MapLike)inputStreamMetadata.mapValues((Function1)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final Partition partition$1;

            public final SystemStreamMetadata.SystemStreamPartitionMetadata apply(SystemStreamMetadata x$9) {
                return (SystemStreamMetadata.SystemStreamPartitionMetadata)x$9.getSystemStreamPartitionMetadata().get(this.partition$1);
            }
            {
                this.partition$1 = partition$1;
            }
        }).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<SystemStream, SystemStreamMetadata.SystemStreamPartitionMetadata> x$10) {
                return x$10._2() != null;
            }
        })).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(SystemStreamMetadata.SystemStreamPartitionMetadata x$11) {
                return x$11.getOldestOffset();
            }
        });
    }

    public TaskStorageManager(TaskName taskName, scala.collection.immutable.Map<String, StorageEngine> taskStores, scala.collection.immutable.Map<String, SystemConsumer> storeConsumers, scala.collection.immutable.Map<String, SystemStream> changeLogSystemStreams, int changeLogStreamPartitions, StreamMetadataCache streamMetadataCache, SSPMetadataCache sspMetadataCache, File nonLoggedStoreBaseDir, File loggedStoreBaseDir, Partition partition, SystemAdmins systemAdmins, scala.collection.immutable.Map<String, Object> changeLogDeleteRetentionsInMs, Clock clock) {
        this.org$apache$samza$storage$TaskStorageManager$$taskName = taskName;
        this.taskStores = taskStores;
        this.org$apache$samza$storage$TaskStorageManager$$storeConsumers = storeConsumers;
        this.org$apache$samza$storage$TaskStorageManager$$changeLogSystemStreams = changeLogSystemStreams;
        this.org$apache$samza$storage$TaskStorageManager$$changeLogStreamPartitions = changeLogStreamPartitions;
        this.streamMetadataCache = streamMetadataCache;
        this.org$apache$samza$storage$TaskStorageManager$$sspMetadataCache = sspMetadataCache;
        this.org$apache$samza$storage$TaskStorageManager$$nonLoggedStoreBaseDir = nonLoggedStoreBaseDir;
        this.org$apache$samza$storage$TaskStorageManager$$loggedStoreBaseDir = loggedStoreBaseDir;
        this.org$apache$samza$storage$TaskStorageManager$$partition = partition;
        this.org$apache$samza$storage$TaskStorageManager$$systemAdmins = systemAdmins;
        this.changeLogDeleteRetentionsInMs = changeLogDeleteRetentionsInMs;
        this.clock = clock;
        Logging$class.$init$(this);
        this.taskStoresToRestore = (scala.collection.immutable.Map)taskStores.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, StorageEngine> x0$1) {
                Tuple2<String, StorageEngine> tuple2 = x0$1;
                if (tuple2 != null) {
                    StorageEngine storageEngine = (StorageEngine)tuple2._2();
                    boolean bl = storageEngine.getStoreProperties().isLoggedStore();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
        this.persistedStores = (scala.collection.immutable.Map)taskStores.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, StorageEngine> x0$2) {
                Tuple2<String, StorageEngine> tuple2 = x0$2;
                if (tuple2 != null) {
                    StorageEngine storageEngine = (StorageEngine)tuple2._2();
                    boolean bl = storageEngine.getStoreProperties().isPersistedToDisk();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
        this.changeLogOldestOffsets = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.fileOffsets = new HashMap<SystemStreamPartition, String>();
        this.offsetFileName = "OFFSET";
    }
}

