/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.storage;

import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.JavaStorageConfig;
import org.apache.samza.config.JavaSystemConfig;
import org.apache.samza.config.StorageConfig;
import org.apache.samza.context.ContainerContext;
import org.apache.samza.context.ContainerContextImpl;
import org.apache.samza.context.JobContext;
import org.apache.samza.context.JobContextImpl;
import org.apache.samza.coordinator.JobModelManager;
import org.apache.samza.coordinator.stream.CoordinatorStreamManager;
import org.apache.samza.job.model.ContainerModel;
import org.apache.samza.job.model.JobModel;
import org.apache.samza.job.model.TaskModel;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.metrics.MetricsRegistryMap;
import org.apache.samza.serializers.ByteSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.storage.ChangelogStreamManager;
import org.apache.samza.storage.StorageEngine;
import org.apache.samza.storage.StorageEngineFactory;
import org.apache.samza.storage.TaskStorageManager;
import org.apache.samza.system.SSPMetadataCache;
import org.apache.samza.system.StreamMetadataCache;
import org.apache.samza.system.SystemAdmins;
import org.apache.samza.system.SystemConsumer;
import org.apache.samza.system.SystemFactory;
import org.apache.samza.system.SystemStream;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.util.CommandLine;
import org.apache.samza.util.ScalaJavaUtil;
import org.apache.samza.util.StreamUtil;
import org.apache.samza.util.SystemClock;
import org.apache.samza.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageRecovery
extends CommandLine {
    private Config jobConfig;
    private int maxPartitionNumber = 0;
    private File storeBaseDir = null;
    private HashMap<String, SystemStream> changeLogSystemStreams = new HashMap();
    private HashMap<String, StorageEngineFactory<?, ?>> storageEngineFactories = new HashMap();
    private Map<String, ContainerModel> containers = new HashMap<String, ContainerModel>();
    private List<TaskStorageManager> taskStorageManagers = new ArrayList<TaskStorageManager>();
    private Logger log = LoggerFactory.getLogger(StorageRecovery.class);
    private SystemAdmins systemAdmins = null;

    StorageRecovery(Config config, String path) {
        this.jobConfig = config;
        this.storeBaseDir = new File(path, "state");
        this.systemAdmins = new SystemAdmins(config);
    }

    private void setup() {
        this.log.info("setting up the recovery...");
        this.getContainerModels();
        this.getChangeLogSystemStreamsAndStorageFactories();
        this.getChangeLogMaxPartitionNumber();
        this.getTaskStorageManagers();
    }

    public void run() {
        this.setup();
        this.log.info("start recovering...");
        this.systemAdmins.start();
        for (TaskStorageManager taskStorageManager : this.taskStorageManagers) {
            taskStorageManager.init();
            taskStorageManager.stopStores();
            this.log.debug("restored " + taskStorageManager.toString());
        }
        this.systemAdmins.stop();
        this.log.info("successfully recovered in " + this.storeBaseDir.toString());
    }

    private void getContainerModels() {
        CoordinatorStreamManager coordinatorStreamManager = new CoordinatorStreamManager(this.jobConfig, (MetricsRegistry)new MetricsRegistryMap());
        coordinatorStreamManager.register(this.getClass().getSimpleName());
        coordinatorStreamManager.start();
        coordinatorStreamManager.bootstrap();
        ChangelogStreamManager changelogStreamManager = new ChangelogStreamManager(coordinatorStreamManager);
        JobModel jobModel = JobModelManager.apply(coordinatorStreamManager.getConfig(), changelogStreamManager.readPartitionMapping()).jobModel();
        this.containers = jobModel.getContainers();
        coordinatorStreamManager.stop();
    }

    private void getChangeLogSystemStreamsAndStorageFactories() {
        JavaStorageConfig config = new JavaStorageConfig(this.jobConfig);
        List<String> storeNames = config.getStoreNames();
        this.log.info("Got store names: " + storeNames.toString());
        for (String storeName : storeNames) {
            String factoryClass;
            String streamName = config.getChangelogStream(storeName);
            this.log.info("stream name for " + storeName + " is " + streamName);
            if (streamName != null) {
                this.changeLogSystemStreams.put(storeName, StreamUtil.getSystemStreamFromNames(streamName));
            }
            if ((factoryClass = config.getStorageFactoryClassName(storeName)) != null) {
                this.storageEngineFactories.put(storeName, Util.getObj(factoryClass, StorageEngineFactory.class));
                continue;
            }
            throw new SamzaException("Missing storage factory for " + storeName + ".");
        }
    }

    private HashMap<String, SystemConsumer> getStoreConsumers() {
        HashMap<String, SystemConsumer> storeConsumers = new HashMap<String, SystemConsumer>();
        Map<String, SystemFactory> systemFactories = new JavaSystemConfig(this.jobConfig).getSystemFactories();
        for (Map.Entry<String, SystemStream> entry : this.changeLogSystemStreams.entrySet()) {
            String storeSystem = entry.getValue().getSystem();
            if (!systemFactories.containsKey(storeSystem)) {
                throw new SamzaException("Changelog system " + storeSystem + " for store " + entry.getKey() + " does not exist in the config.");
            }
            storeConsumers.put(entry.getKey(), systemFactories.get(storeSystem).getConsumer(storeSystem, this.jobConfig, (MetricsRegistry)new MetricsRegistryMap()));
        }
        return storeConsumers;
    }

    private void getChangeLogMaxPartitionNumber() {
        int maxPartitionId = 0;
        for (ContainerModel containerModel : this.containers.values()) {
            for (TaskModel taskModel : containerModel.getTasks().values()) {
                maxPartitionId = Math.max(maxPartitionId, taskModel.getChangelogPartition().getPartitionId());
            }
        }
        this.maxPartitionNumber = maxPartitionId + 1;
    }

    private void getTaskStorageManagers() {
        SystemClock clock = SystemClock.instance();
        StreamMetadataCache streamMetadataCache = new StreamMetadataCache(this.systemAdmins, 5000, clock);
        SSPMetadataCache sspMetadataCache = new SSPMetadataCache(this.systemAdmins, Duration.ofSeconds(5L), clock, Collections.emptySet());
        for (ContainerModel containerModel : this.containers.values()) {
            HashMap<String, StorageEngine> taskStores = new HashMap<String, StorageEngine>();
            ContainerContextImpl containerContext = new ContainerContextImpl(containerModel, (MetricsRegistry)new MetricsRegistryMap());
            for (TaskModel taskModel : containerModel.getTasks().values()) {
                HashMap<String, SystemConsumer> storeConsumers = this.getStoreConsumers();
                for (Map.Entry<String, StorageEngineFactory<?, ?>> entry : this.storageEngineFactories.entrySet()) {
                    String storeName = entry.getKey();
                    if (!this.changeLogSystemStreams.containsKey(storeName)) continue;
                    SystemStreamPartition changeLogSystemStreamPartition = new SystemStreamPartition(this.changeLogSystemStreams.get(storeName), taskModel.getChangelogPartition());
                    File storePartitionDir = TaskStorageManager.getStorePartitionDir(this.storeBaseDir, storeName, taskModel.getTaskName());
                    this.log.info("Got storage engine directory: " + storePartitionDir);
                    StorageEngine storageEngine = entry.getValue().getStorageEngine(storeName, storePartitionDir, (Serde)new ByteSerde(), (Serde)new ByteSerde(), null, (MetricsRegistry)new MetricsRegistryMap(), changeLogSystemStreamPartition, (JobContext)JobContextImpl.fromConfigWithDefaults(this.jobConfig), (ContainerContext)containerContext);
                    taskStores.put(storeName, storageEngine);
                }
                TaskStorageManager taskStorageManager = new TaskStorageManager(taskModel.getTaskName(), ScalaJavaUtil.toScalaMap(taskStores), ScalaJavaUtil.toScalaMap(storeConsumers), ScalaJavaUtil.toScalaMap(this.changeLogSystemStreams), this.maxPartitionNumber, streamMetadataCache, sspMetadataCache, this.storeBaseDir, this.storeBaseDir, taskModel.getChangelogPartition(), this.systemAdmins, new StorageConfig(this.jobConfig).getChangeLogDeleteRetentionsInMs(), new SystemClock());
                this.taskStorageManagers.add(taskStorageManager);
            }
        }
    }
}

