/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.storage;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Map;
import org.apache.samza.system.SystemAdmin;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageManagerUtil {
    private static final Logger LOG = LoggerFactory.getLogger(StorageManagerUtil.class);

    public static String getStartingOffset(SystemStreamPartition ssp, SystemAdmin admin, String fileOffset, String oldestOffset) {
        String startingOffset = oldestOffset;
        if (fileOffset != null) {
            String resumeOffset = (String)admin.getOffsetsAfter((Map)ImmutableMap.of((Object)ssp, (Object)fileOffset)).get(ssp);
            if (admin.offsetComparator(oldestOffset, resumeOffset) <= 0) {
                startingOffset = resumeOffset;
            } else {
                LOG.warn("Local store offset {} is lower than the oldest offset {} of the source stream. The values between these offsets cannot be restored.", (Object)resumeOffset, (Object)oldestOffset);
            }
        }
        return startingOffset;
    }

    public static boolean isStaleStore(File storeDir, String offsetFileName, long storeDeleteRetentionInMs, long currentTimeMs) {
        boolean isStaleStore = false;
        String storePath = storeDir.toPath().toString();
        if (storeDir.exists()) {
            File offsetFileRef = new File(storeDir, offsetFileName);
            long offsetFileLastModifiedTime = offsetFileRef.lastModified();
            if (currentTimeMs - offsetFileLastModifiedTime >= storeDeleteRetentionInMs) {
                LOG.info(String.format("Store: %s is stale since lastModifiedTime of offset file: %d, is older than store deleteRetentionMs: %d.", storePath, offsetFileLastModifiedTime, storeDeleteRetentionInMs));
                isStaleStore = true;
            }
        } else {
            LOG.info("Storage partition directory: {} does not exist.", (Object)storePath);
        }
        return isStaleStore;
    }

    public static boolean isOffsetFileValid(File storeDir, String offsetFileName) {
        boolean hasValidOffsetFile = false;
        if (storeDir.exists()) {
            String offsetContents = StorageManagerUtil.readOffsetFile(storeDir, offsetFileName);
            if (offsetContents != null && !offsetContents.isEmpty()) {
                hasValidOffsetFile = true;
            } else {
                LOG.info("Offset file is not valid for store: {}.", (Object)storeDir.toPath());
            }
        }
        return hasValidOffsetFile;
    }

    public static String readOffsetFile(File storagePartitionDir, String offsetFileName) {
        String offset = null;
        File offsetFileRef = new File(storagePartitionDir, offsetFileName);
        String storePath = storagePartitionDir.getPath();
        if (offsetFileRef.exists()) {
            LOG.info("Found offset file in storage partition directory: {}", (Object)storePath);
            try {
                offset = FileUtil.readWithChecksum(offsetFileRef);
            }
            catch (Exception e) {
                LOG.warn("Failed to read offset file in storage partition directory: {}", (Object)storePath, (Object)e);
            }
        } else {
            LOG.info("No offset file found in storage partition directory: {}", (Object)storePath);
        }
        return offset;
    }
}

