/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.storage;

import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSet;
import org.apache.samza.config.Config;
import org.apache.samza.config.MapConfig;
import org.apache.samza.storage.StorageRecovery;
import org.apache.samza.util.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateStorageTool
extends CommandLine {
    private ArgumentAcceptingOptionSpec<String> newPathArgu = this.parser().accepts("path", "path of the new state storage").withRequiredArg().ofType(String.class).describedAs("path");
    private String newPath = "";
    private Logger log = LoggerFactory.getLogger(StateStorageTool.class);

    @Override
    public MapConfig loadConfig(OptionSet options) {
        MapConfig config = super.loadConfig(options);
        if (options.has(this.newPathArgu)) {
            this.newPath = (String)options.valueOf(this.newPathArgu);
            this.log.info("new state storage is " + this.newPath);
        }
        return config;
    }

    public String getPath() {
        return this.newPath;
    }

    public static void main(String[] args) {
        StateStorageTool tool = new StateStorageTool();
        OptionSet options = tool.parser().parse(args);
        MapConfig config = tool.loadConfig(options);
        String path = tool.getPath();
        StorageRecovery storageRecovery = new StorageRecovery((Config)config, path);
        storageRecovery.run();
    }
}

