/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.JavaStorageConfig;
import org.apache.samza.config.JavaSystemConfig;
import org.apache.samza.container.TaskName;
import org.apache.samza.coordinator.stream.CoordinatorStreamManager;
import org.apache.samza.coordinator.stream.messages.CoordinatorStreamMessage;
import org.apache.samza.coordinator.stream.messages.SetChangelogMapping;
import org.apache.samza.system.StreamSpec;
import org.apache.samza.system.SystemAdmin;
import org.apache.samza.system.SystemStream;
import org.apache.samza.util.StreamUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangelogStreamManager {
    private static final Logger LOG = LoggerFactory.getLogger(ChangelogStreamManager.class);
    private static final String SOURCE = "JobModelManager";
    private final CoordinatorStreamManager coordinatorStreamManager;

    public ChangelogStreamManager(CoordinatorStreamManager coordinatorStreamManager) {
        this.coordinatorStreamManager = coordinatorStreamManager;
    }

    public Map<TaskName, Integer> readPartitionMapping() {
        LOG.debug("Reading changelog partition information");
        HashMap<TaskName, Integer> changelogMapping = new HashMap<TaskName, Integer>();
        for (CoordinatorStreamMessage coordinatorStreamMessage : this.coordinatorStreamManager.getBootstrappedStream("set-changelog")) {
            SetChangelogMapping changelogMapEntry = new SetChangelogMapping(coordinatorStreamMessage);
            changelogMapping.put(new TaskName(changelogMapEntry.getTaskName()), changelogMapEntry.getPartition());
            LOG.debug("TaskName: {} is mapped to {}", (Object)changelogMapEntry.getTaskName(), (Object)changelogMapEntry.getPartition());
        }
        return changelogMapping;
    }

    public void writePartitionMapping(Map<TaskName, Integer> changelogEntries) {
        LOG.debug("Updating changelog information with: ");
        for (Map.Entry<TaskName, Integer> entry : changelogEntries.entrySet()) {
            LOG.debug("TaskName: {} to Partition: {}", (Object)entry.getKey().getTaskName(), (Object)entry.getValue());
            this.coordinatorStreamManager.send(new SetChangelogMapping(SOURCE, entry.getKey().getTaskName(), entry.getValue()));
        }
    }

    public void updatePartitionMapping(Map<TaskName, Integer> prevChangelogEntries, Map<TaskName, Integer> newChangelogEntries) {
        HashMap<TaskName, Integer> combinedEntries = new HashMap<TaskName, Integer>(newChangelogEntries);
        combinedEntries.putAll(prevChangelogEntries);
        this.writePartitionMapping(combinedEntries);
    }

    public static void createChangelogStreams(Config config, int maxChangeLogStreamPartitions) {
        JavaStorageConfig storageConfig = new JavaStorageConfig(config);
        Map<String, SystemStream> storeNameSystemStreamMapping = storageConfig.getStoreNames().stream().filter(name -> StringUtils.isNotBlank((CharSequence)storageConfig.getChangelogStream((String)name))).collect(Collectors.toMap(name -> name, name -> StreamUtil.getSystemStreamFromNames(storageConfig.getChangelogStream((String)name))));
        JavaSystemConfig systemConfig = new JavaSystemConfig(config);
        storeNameSystemStreamMapping.forEach((storeName, systemStream) -> {
            SystemAdmin systemAdmin = systemConfig.getSystemAdmin(systemStream.getSystem());
            if (systemAdmin == null) {
                throw new SamzaException(String.format("Error creating changelog. Changelog on store %s uses system %s, which is missing from the configuration.", storeName, systemStream.getSystem()));
            }
            StreamSpec changelogSpec = StreamSpec.createChangeLogStreamSpec((String)systemStream.getStream(), (String)systemStream.getSystem(), (int)maxChangeLogStreamPartitions);
            systemAdmin.start();
            if (systemAdmin.createStream(changelogSpec)) {
                LOG.info(String.format("created changelog stream %s.", systemStream.getStream()));
            } else {
                LOG.info(String.format("changelog stream %s already exists.", systemStream.getStream()));
            }
            systemAdmin.validateStream(changelogSpec);
            if (storageConfig.getAccessLogEnabled((String)storeName)) {
                String accesslogStream = storageConfig.getAccessLogStream(systemStream.getStream());
                StreamSpec accesslogSpec = new StreamSpec(accesslogStream, accesslogStream, systemStream.getSystem(), maxChangeLogStreamPartitions);
                systemAdmin.createStream(accesslogSpec);
                systemAdmin.validateStream(accesslogSpec);
            }
            systemAdmin.stop();
        });
    }
}

