/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.standalone;

import java.util.Collections;
import org.apache.samza.checkpoint.CheckpointManager;
import org.apache.samza.config.ApplicationConfig;
import org.apache.samza.config.Config;
import org.apache.samza.config.ConfigException;
import org.apache.samza.config.JobConfig;
import org.apache.samza.config.TaskConfigJava;
import org.apache.samza.coordinator.JobCoordinator;
import org.apache.samza.coordinator.JobCoordinatorListener;
import org.apache.samza.coordinator.JobModelManager;
import org.apache.samza.job.model.JobModel;
import org.apache.samza.runtime.ProcessorIdGenerator;
import org.apache.samza.storage.ChangelogStreamManager;
import org.apache.samza.system.StreamMetadataCache;
import org.apache.samza.system.SystemAdmins;
import org.apache.samza.util.SystemClock;
import org.apache.samza.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PassthroughJobCoordinator
implements JobCoordinator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PassthroughJobCoordinator.class);
    private final String processorId;
    private final Config config;
    private JobCoordinatorListener coordinatorListener = null;

    public PassthroughJobCoordinator(Config config) {
        this.processorId = this.createProcessorId(config);
        this.config = config;
    }

    @Override
    public void start() {
        JobModel jobModel;
        block6: {
            jobModel = null;
            try {
                jobModel = this.getJobModel();
                CheckpointManager checkpointManager = new TaskConfigJava(jobModel.getConfig()).getCheckpointManager(null);
                if (checkpointManager != null) {
                    checkpointManager.createResources();
                }
                ChangelogStreamManager.createChangelogStreams(this.config, jobModel.maxChangeLogStreamPartitions);
            }
            catch (Exception e) {
                LOGGER.error("Exception while trying to getJobModel.", (Throwable)e);
                if (this.coordinatorListener == null) break block6;
                this.coordinatorListener.onCoordinatorFailure(e);
            }
        }
        if (jobModel != null && jobModel.getContainers().containsKey(this.processorId)) {
            if (this.coordinatorListener != null) {
                this.coordinatorListener.onJobModelExpired();
                this.coordinatorListener.onNewJobModel(this.processorId, jobModel);
            }
        } else {
            this.stop();
        }
    }

    @Override
    public void stop() {
        if (this.coordinatorListener != null) {
            this.coordinatorListener.onJobModelExpired();
            this.coordinatorListener.onCoordinatorStop();
        }
    }

    @Override
    public void setListener(JobCoordinatorListener listener) {
        this.coordinatorListener = listener;
    }

    @Override
    public JobModel getJobModel() {
        SystemAdmins systemAdmins = new SystemAdmins(this.config);
        StreamMetadataCache streamMetadataCache = new StreamMetadataCache(systemAdmins, 5000, SystemClock.instance());
        systemAdmins.start();
        String containerId = Integer.toString(this.config.getInt(JobConfig.PROCESSOR_ID()));
        JobModel jobModel = JobModelManager.readJobModel(this.config, Collections.emptyMap(), null, streamMetadataCache, Collections.singletonList(containerId));
        systemAdmins.stop();
        return jobModel;
    }

    @Override
    public String getProcessorId() {
        return this.processorId;
    }

    private String createProcessorId(Config config) {
        ApplicationConfig appConfig = new ApplicationConfig(config);
        if (appConfig.getProcessorId() != null) {
            return appConfig.getProcessorId();
        }
        if (appConfig.getAppProcessorIdGeneratorClass() != null) {
            ProcessorIdGenerator idGenerator = Util.getObj(appConfig.getAppProcessorIdGeneratorClass(), ProcessorIdGenerator.class);
            return idGenerator.generateProcessorId(config);
        }
        throw new ConfigException(String.format("Expected either %s or %s to be configured", "processor.id", "app.processor-id-generator.class"));
    }
}

