/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.serializers.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.samza.Partition;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.MapConfig;
import org.apache.samza.container.TaskName;
import org.apache.samza.job.model.ContainerModel;
import org.apache.samza.job.model.JobModel;
import org.apache.samza.job.model.TaskModel;
import org.apache.samza.serializers.model.JsonContainerModelMixIn;
import org.apache.samza.serializers.model.JsonJobModelMixIn;
import org.apache.samza.serializers.model.JsonTaskModelMixIn;
import org.apache.samza.system.SystemStream;
import org.apache.samza.system.SystemStreamPartition;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.KeyDeserializer;
import org.codehaus.jackson.map.MapperConfig;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.PropertyNamingStrategy;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.introspect.AnnotatedField;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.module.SimpleModule;
import org.codehaus.jackson.type.TypeReference;

public class SamzaObjectMapper {
    private static final ObjectMapper OBJECT_MAPPER = SamzaObjectMapper.getObjectMapper();

    public static ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule("SamzaModule", new Version(1, 0, 0, ""));
        module.addSerializer(Partition.class, (JsonSerializer)new PartitionSerializer());
        module.addSerializer(SystemStreamPartition.class, (JsonSerializer)new SystemStreamPartitionSerializer());
        module.addKeySerializer(SystemStreamPartition.class, (JsonSerializer)new SystemStreamPartitionKeySerializer());
        module.addSerializer(TaskName.class, (JsonSerializer)new TaskNameSerializer());
        module.addDeserializer(Partition.class, (JsonDeserializer)new PartitionDeserializer());
        module.addDeserializer(SystemStreamPartition.class, (JsonDeserializer)new SystemStreamPartitionDeserializer());
        module.addKeyDeserializer(SystemStreamPartition.class, (KeyDeserializer)new SystemStreamPartitionKeyDeserializer());
        module.addDeserializer(Config.class, (JsonDeserializer)new ConfigDeserializer());
        mapper.getSerializationConfig().addMixInAnnotations(TaskModel.class, JsonTaskModelMixIn.class);
        mapper.getDeserializationConfig().addMixInAnnotations(TaskModel.class, JsonTaskModelMixIn.class);
        mapper.getSerializationConfig().addMixInAnnotations(ContainerModel.class, JsonContainerModelMixIn.class);
        mapper.getSerializationConfig().addMixInAnnotations(JobModel.class, JsonJobModelMixIn.class);
        mapper.getDeserializationConfig().addMixInAnnotations(JobModel.class, JsonJobModelMixIn.class);
        module.addDeserializer(ContainerModel.class, (JsonDeserializer)new JsonDeserializer<ContainerModel>(){

            public ContainerModel deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                String id;
                ObjectCodec oc = jp.getCodec();
                JsonNode node = oc.readTree(jp);
                if (node.get("processor-id") == null) {
                    if (node.get("container-id") == null) {
                        throw new SamzaException(String.format("JobModel was missing %s and %s. This should never happen. JobModel corrupt!", "processor-id", "container-id"));
                    }
                    id = String.valueOf(node.get("container-id").getIntValue());
                } else {
                    id = node.get("processor-id").getTextValue();
                }
                Map tasksMapping = (Map)OBJECT_MAPPER.readValue(node.get("tasks"), (TypeReference)new TypeReference<Map<TaskName, TaskModel>>(){});
                return new ContainerModel(id, tasksMapping);
            }
        });
        mapper.setPropertyNamingStrategy((PropertyNamingStrategy)new CamelCaseToDashesStrategy());
        mapper.registerModule((Module)module);
        return mapper;
    }

    public static class CamelCaseToDashesStrategy
    extends PropertyNamingStrategy {
        public String nameForField(MapperConfig<?> config, AnnotatedField field, String defaultName) {
            return this.convert(defaultName);
        }

        public String nameForGetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
            return this.convert(defaultName);
        }

        public String nameForSetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
            return this.convert(defaultName);
        }

        public String convert(String defaultName) {
            StringBuilder builder = new StringBuilder();
            char[] arr = defaultName.toCharArray();
            for (int i = 0; i < arr.length; ++i) {
                if (Character.isUpperCase(arr[i])) {
                    builder.append("-" + Character.toLowerCase(arr[i]));
                    continue;
                }
                builder.append(arr[i]);
            }
            return builder.toString();
        }
    }

    public static class SystemStreamPartitionDeserializer
    extends JsonDeserializer<SystemStreamPartition> {
        public SystemStreamPartition deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JsonProcessingException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = oc.readTree(jsonParser);
            String system = node.get("system").getTextValue();
            String stream = node.get("stream").getTextValue();
            Partition partition = new Partition(node.get("partition").getIntValue());
            return new SystemStreamPartition(system, stream, partition);
        }
    }

    public static class SystemStreamPartitionSerializer
    extends JsonSerializer<SystemStreamPartition> {
        public void serialize(SystemStreamPartition systemStreamPartition, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException, JsonProcessingException {
            HashMap<String, String> systemStreamPartitionMap = new HashMap<String, String>();
            systemStreamPartitionMap.put("system", systemStreamPartition.getSystem());
            systemStreamPartitionMap.put("stream", systemStreamPartition.getStream());
            systemStreamPartitionMap.put("partition", (String)systemStreamPartition.getPartition());
            jsonGenerator.writeObject(systemStreamPartitionMap);
        }
    }

    public static class SystemStreamPartitionKeyDeserializer
    extends KeyDeserializer {
        public Object deserializeKey(String sspString, DeserializationContext ctxt) throws IOException {
            int idx = sspString.indexOf(46);
            int lastIdx = sspString.lastIndexOf(46);
            if (idx < 0 || lastIdx < 0) {
                throw new IllegalArgumentException("System stream partition expected in format 'system.stream.partition");
            }
            return new SystemStreamPartition(new SystemStream(sspString.substring(0, idx), sspString.substring(idx + 1, lastIdx)), new Partition(Integer.parseInt(sspString.substring(lastIdx + 1))));
        }
    }

    public static class SystemStreamPartitionKeySerializer
    extends JsonSerializer<SystemStreamPartition> {
        public void serialize(SystemStreamPartition ssp, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            String sspString = ssp.getSystem() + "." + ssp.getStream() + "." + String.valueOf(ssp.getPartition().getPartitionId());
            jgen.writeFieldName(sspString);
        }
    }

    public static class TaskNameDeserializer
    extends JsonDeserializer<TaskName> {
        public TaskName deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JsonProcessingException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = oc.readTree(jsonParser);
            return new TaskName(node.getTextValue());
        }
    }

    public static class TaskNameSerializer
    extends JsonSerializer<TaskName> {
        public void serialize(TaskName taskName, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException, JsonProcessingException {
            jsonGenerator.writeObject((Object)taskName.toString());
        }
    }

    public static class PartitionDeserializer
    extends JsonDeserializer<Partition> {
        public Partition deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JsonProcessingException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = oc.readTree(jsonParser);
            return new Partition(node.getIntValue());
        }
    }

    public static class PartitionSerializer
    extends JsonSerializer<Partition> {
        public void serialize(Partition partition, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException, JsonProcessingException {
            jsonGenerator.writeObject((Object)partition.getPartitionId());
        }
    }

    public static class ConfigDeserializer
    extends JsonDeserializer<Config> {
        public Config deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JsonProcessingException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = oc.readTree(jsonParser);
            return new MapConfig((Map)OBJECT_MAPPER.readValue(node, (TypeReference)new TypeReference<Map<String, String>>(){}));
        }
    }
}

