/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.serializers;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.samza.metrics.reporter.MetricsSnapshot;
import org.apache.samza.serializers.Serde;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsSnapshotSerdeV2
implements Serde<MetricsSnapshot> {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsSnapshotSerdeV2.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    public MetricsSnapshotSerdeV2() {
        this.objectMapper.enableDefaultTyping(ObjectMapper.DefaultTyping.OBJECT_AND_NON_CONCRETE);
    }

    public MetricsSnapshot fromBytes(byte[] bytes) {
        try {
            return MetricsSnapshot.fromMap((Map)this.objectMapper.readValue(bytes, new HashMap().getClass()));
        }
        catch (IOException e) {
            LOG.info("Exception while deserializing", (Throwable)e);
            return null;
        }
    }

    public byte[] toBytes(MetricsSnapshot metricsSnapshot) {
        try {
            return this.objectMapper.writeValueAsString((Object)this.convertMap(metricsSnapshot.getAsMap())).getBytes("UTF-8");
        }
        catch (IOException e) {
            LOG.info("Exception while serializing", (Throwable)e);
            return null;
        }
    }

    private HashMap convertMap(Map<String, Object> map) {
        HashMap<String, Object> retVal = new HashMap<String, Object>(map);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!(entry.getValue() instanceof Map)) continue;
            retVal.put(entry.getKey(), this.convertMap((Map)entry.getValue()));
        }
        return retVal;
    }
}

