/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.serializers;

import java.util.Arrays;
import org.apache.samza.SamzaException;
import org.apache.samza.serializers.JsonSerdeV2;
import org.apache.samza.serializers.Serde;
import org.apache.samza.system.EndOfStreamMessage;
import org.apache.samza.system.MessageType;
import org.apache.samza.system.WatermarkMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntermediateMessageSerde
implements Serde<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntermediateMessageSerde.class);
    private final Serde userMessageSerde;
    private final Serde<WatermarkMessage> watermarkSerde;
    private final Serde<EndOfStreamMessage> eosSerde;

    public IntermediateMessageSerde(Serde userMessageSerde) {
        this.userMessageSerde = userMessageSerde;
        this.watermarkSerde = new JsonSerdeV2(WatermarkMessage.class);
        this.eosSerde = new JsonSerdeV2(EndOfStreamMessage.class);
    }

    public Object fromBytes(byte[] bytes) {
        try {
            Object object;
            MessageType type = MessageType.values()[bytes[0]];
            byte[] data = Arrays.copyOfRange(bytes, 1, bytes.length);
            switch (type) {
                case USER_MESSAGE: {
                    object = this.userMessageSerde.fromBytes(data);
                    break;
                }
                case WATERMARK: {
                    object = this.watermarkSerde.fromBytes(data);
                    break;
                }
                case END_OF_STREAM: {
                    object = this.eosSerde.fromBytes(data);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Message type %s is not supported", type.name()));
                }
            }
            return object;
        }
        catch (UnsupportedOperationException ue) {
            throw new SamzaException((Throwable)ue);
        }
        catch (Exception e) {
            try {
                return this.userMessageSerde.fromBytes(bytes);
            }
            catch (Exception umse) {
                LOGGER.error("Error deserializing from both intermediate message serde and user message serde. Original exception: ", (Throwable)e);
                throw umse;
            }
        }
    }

    public byte[] toBytes(Object object) {
        byte[] data;
        MessageType type = MessageType.of((Object)object);
        switch (type) {
            case USER_MESSAGE: {
                data = this.userMessageSerde.toBytes(object);
                break;
            }
            case WATERMARK: {
                data = this.watermarkSerde.toBytes((Object)((WatermarkMessage)object));
                break;
            }
            case END_OF_STREAM: {
                data = this.eosSerde.toBytes((Object)((EndOfStreamMessage)object));
                break;
            }
            default: {
                throw new SamzaException("Unknown message type: " + type.name());
            }
        }
        byte[] bytes = new byte[data.length + 1];
        bytes[0] = (byte)type.ordinal();
        System.arraycopy(data, 0, bytes, 1, data.length);
        return bytes;
    }
}

