/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.runtime;

import java.time.Duration;
import java.util.List;
import org.apache.samza.SamzaException;
import org.apache.samza.application.SamzaApplication;
import org.apache.samza.application.descriptors.ApplicationDescriptor;
import org.apache.samza.application.descriptors.ApplicationDescriptorImpl;
import org.apache.samza.application.descriptors.ApplicationDescriptorUtil;
import org.apache.samza.config.Config;
import org.apache.samza.config.JobConfig;
import org.apache.samza.execution.RemoteJobPlanner;
import org.apache.samza.job.ApplicationStatus;
import org.apache.samza.job.JobRunner;
import org.apache.samza.runtime.ApplicationRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteApplicationRunner
implements ApplicationRunner {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteApplicationRunner.class);
    private static final long DEFAULT_SLEEP_DURATION_MS = 2000L;
    private final ApplicationDescriptorImpl<? extends ApplicationDescriptor> appDesc;
    private final RemoteJobPlanner planner;

    public RemoteApplicationRunner(SamzaApplication app, Config config) {
        this.appDesc = ApplicationDescriptorUtil.getAppDescriptor(app, config);
        this.planner = new RemoteJobPlanner(this.appDesc);
    }

    public void run() {
        try {
            List<JobConfig> jobConfigs = this.planner.prepareJobs();
            if (jobConfigs.isEmpty()) {
                throw new SamzaException("No jobs to run.");
            }
            jobConfigs.forEach(jobConfig -> {
                LOG.info("Starting job {} with config {}", jobConfig.getName(), jobConfig);
                JobRunner runner = new JobRunner((Config)jobConfig);
                runner.run(true);
            });
        }
        catch (Throwable t) {
            throw new SamzaException("Failed to run application", t);
        }
    }

    public void kill() {
        try {
            JobConfig jc = new JobConfig(this.appDesc.getConfig());
            LOG.info("Killing job {}", jc.getName());
            JobRunner runner = new JobRunner((Config)jc);
            runner.kill();
        }
        catch (Throwable t) {
            throw new SamzaException("Failed to kill application", t);
        }
    }

    public ApplicationStatus status() {
        try {
            JobConfig jc = new JobConfig(this.appDesc.getConfig());
            return this.getApplicationStatus(jc);
        }
        catch (Throwable t) {
            throw new SamzaException("Failed to get status for application", t);
        }
    }

    public void waitForFinish() {
        this.waitForFinish(Duration.ofMillis(0L));
    }

    public boolean waitForFinish(Duration timeout) {
        JobConfig jobConfig = new JobConfig(this.appDesc.getConfig());
        boolean finished = true;
        long timeoutInMs = timeout.toMillis();
        long startTimeInMs = System.currentTimeMillis();
        long timeElapsed = 0L;
        long sleepDurationInMs = timeoutInMs < 1L ? 2000L : Math.min(timeoutInMs, 2000L);
        try {
            while (timeoutInMs < 1L || timeElapsed <= timeoutInMs) {
                ApplicationStatus status = this.getApplicationStatus(jobConfig);
                if (status == ApplicationStatus.SuccessfulFinish || status == ApplicationStatus.UnsuccessfulFinish) {
                    LOG.info("Application finished with status {}", (Object)status);
                    break;
                }
                Thread.sleep(sleepDurationInMs);
                timeElapsed = System.currentTimeMillis() - startTimeInMs;
            }
            if (timeElapsed > timeoutInMs) {
                LOG.warn("Timed out waiting for application to finish.");
                finished = false;
            }
        }
        catch (Exception e) {
            LOG.error("Error waiting for application to finish", (Throwable)e);
            throw new SamzaException((Throwable)e);
        }
        return finished;
    }

    ApplicationStatus getApplicationStatus(JobConfig jobConfig) {
        JobRunner runner = new JobRunner((Config)jobConfig);
        ApplicationStatus status = runner.status();
        LOG.debug("Status is {} for job {}", new Object[]{status, jobConfig.getName()});
        return status;
    }
}

