/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.runtime;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.samza.SamzaException;
import org.apache.samza.application.ApplicationUtil;
import org.apache.samza.application.descriptors.ApplicationDescriptor;
import org.apache.samza.application.descriptors.ApplicationDescriptorImpl;
import org.apache.samza.application.descriptors.ApplicationDescriptorUtil;
import org.apache.samza.config.Config;
import org.apache.samza.config.JobConfig;
import org.apache.samza.config.ShellCommandConfig;
import org.apache.samza.container.ContainerHeartbeatClient;
import org.apache.samza.container.ContainerHeartbeatMonitor;
import org.apache.samza.container.SamzaContainer;
import org.apache.samza.container.SamzaContainer$;
import org.apache.samza.container.SamzaContainerListener;
import org.apache.samza.context.ApplicationContainerContext;
import org.apache.samza.context.ApplicationContainerContextFactory;
import org.apache.samza.context.ApplicationTaskContext;
import org.apache.samza.context.ApplicationTaskContextFactory;
import org.apache.samza.context.JobContextImpl;
import org.apache.samza.job.model.JobModel;
import org.apache.samza.metrics.MetricsReporter;
import org.apache.samza.runtime.ProcessorContext;
import org.apache.samza.runtime.ProcessorLifecycleListener;
import org.apache.samza.task.TaskFactory;
import org.apache.samza.task.TaskFactoryUtil;
import org.apache.samza.util.SamzaUncaughtExceptionHandler;
import org.apache.samza.util.ScalaJavaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import scala.Option;

public class LocalContainerRunner {
    private static final Logger log = LoggerFactory.getLogger(LocalContainerRunner.class);
    private static volatile Throwable containerRunnerException = null;

    public static void main(String[] args) throws Exception {
        Thread.setDefaultUncaughtExceptionHandler(new SamzaUncaughtExceptionHandler(() -> {
            log.info("Exiting process now.");
            System.exit(1);
        }));
        String containerId = System.getenv(ShellCommandConfig.ENV_CONTAINER_ID());
        log.info(String.format("Got container ID: %s", containerId));
        System.out.println(String.format("Container ID: %s", containerId));
        String coordinatorUrl = System.getenv(ShellCommandConfig.ENV_COORDINATOR_URL());
        log.info(String.format("Got coordinator URL: %s", coordinatorUrl));
        System.out.println(String.format("Coordinator URL: %s", coordinatorUrl));
        int delay = new Random().nextInt(SamzaContainer.DEFAULT_READ_JOBMODEL_DELAY_MS()) + 1;
        JobModel jobModel = SamzaContainer.readJobModel(coordinatorUrl, delay);
        Config config = jobModel.getConfig();
        JobConfig jobConfig = new JobConfig(config);
        if (jobConfig.getName().isEmpty()) {
            throw new SamzaException("can not find the job name");
        }
        String jobName = (String)jobConfig.getName().get();
        String jobId = jobConfig.getJobId();
        MDC.put((String)"containerName", (String)("samza-container-" + containerId));
        MDC.put((String)"jobName", (String)jobName);
        MDC.put((String)"jobId", (String)jobId);
        ApplicationDescriptorImpl<? extends ApplicationDescriptor> appDesc = ApplicationDescriptorUtil.getAppDescriptor(ApplicationUtil.fromConfig(config), config);
        LocalContainerRunner.run(appDesc, containerId, jobModel, config);
        System.exit(0);
    }

    private static void run(ApplicationDescriptorImpl<? extends ApplicationDescriptor> appDesc, String containerId, JobModel jobModel, Config config) {
        TaskFactory taskFactory = TaskFactoryUtil.getTaskFactory(appDesc);
        SamzaContainer container = SamzaContainer$.MODULE$.apply(containerId, jobModel, ScalaJavaUtil.toScalaMap(LocalContainerRunner.loadMetricsReporters(appDesc, containerId, config)), taskFactory, JobContextImpl.fromConfigWithDefaults(config), (Option<ApplicationContainerContextFactory<ApplicationContainerContext>>)Option.apply(appDesc.getApplicationContainerContextFactory().orElse(null)), (Option<ApplicationTaskContextFactory<ApplicationTaskContext>>)Option.apply(appDesc.getApplicationTaskContextFactory().orElse(null)));
        final ProcessorLifecycleListener listener = appDesc.getProcessorLifecycleListenerFactory().createInstance(new ProcessorContext(){}, config);
        container.setContainerListener(new SamzaContainerListener(){

            @Override
            public void beforeStart() {
                log.info("Before starting the container.");
                listener.beforeStart();
            }

            @Override
            public void afterStart() {
                log.info("Container Started");
                listener.afterStart();
            }

            @Override
            public void afterStop() {
                log.info("Container Stopped");
                listener.afterStop();
            }

            @Override
            public void afterFailure(Throwable t) {
                log.info("Container Failed");
                containerRunnerException = t;
                listener.afterFailure(t);
            }
        });
        ContainerHeartbeatMonitor heartbeatMonitor = LocalContainerRunner.createContainerHeartbeatMonitor(container);
        if (heartbeatMonitor != null) {
            heartbeatMonitor.start();
        }
        container.run();
        if (heartbeatMonitor != null) {
            heartbeatMonitor.stop();
        }
        if (containerRunnerException != null) {
            log.error("Container stopped with Exception. Exiting process now.", containerRunnerException);
            System.exit(1);
        }
    }

    private static Map<String, MetricsReporter> loadMetricsReporters(ApplicationDescriptorImpl<? extends ApplicationDescriptor> appDesc, String containerId, Config config) {
        HashMap<String, MetricsReporter> reporters = new HashMap<String, MetricsReporter>();
        appDesc.getMetricsReporterFactories().forEach((name, factory) -> reporters.put((String)name, factory.getMetricsReporter(name, containerId, config)));
        return reporters;
    }

    private static ContainerHeartbeatMonitor createContainerHeartbeatMonitor(SamzaContainer container) {
        String coordinatorUrl = System.getenv(ShellCommandConfig.ENV_COORDINATOR_URL());
        String executionEnvContainerId = System.getenv(ShellCommandConfig.ENV_EXECUTION_ENV_CONTAINER_ID());
        if (executionEnvContainerId != null) {
            log.info("Got execution environment container id: {}", (Object)executionEnvContainerId);
            return new ContainerHeartbeatMonitor(() -> {
                try {
                    container.shutdown();
                    containerRunnerException = new SamzaException("Container shutdown due to expired heartbeat");
                }
                catch (Exception e) {
                    log.error("Heartbeat monitor failed to shutdown the container gracefully. Exiting process.", (Throwable)e);
                    System.exit(1);
                }
            }, new ContainerHeartbeatClient(coordinatorUrl, executionEnvContainerId));
        }
        log.warn("Execution environment container id not set. Container heartbeat monitor will not be created");
        return null;
    }
}

