/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.runtime;

import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.samza.SamzaException;
import org.apache.samza.application.SamzaApplication;
import org.apache.samza.application.descriptors.ApplicationDescriptor;
import org.apache.samza.application.descriptors.ApplicationDescriptorImpl;
import org.apache.samza.application.descriptors.ApplicationDescriptorUtil;
import org.apache.samza.config.ApplicationConfig;
import org.apache.samza.config.Config;
import org.apache.samza.config.JobConfig;
import org.apache.samza.execution.LocalJobPlanner;
import org.apache.samza.job.ApplicationStatus;
import org.apache.samza.metrics.MetricsReporter;
import org.apache.samza.processor.StreamProcessor;
import org.apache.samza.runtime.ApplicationRunner;
import org.apache.samza.runtime.ProcessorContext;
import org.apache.samza.runtime.ProcessorLifecycleListener;
import org.apache.samza.task.TaskFactory;
import org.apache.samza.task.TaskFactoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalApplicationRunner
implements ApplicationRunner {
    private static final Logger LOG = LoggerFactory.getLogger(LocalApplicationRunner.class);
    private final ApplicationDescriptorImpl<? extends ApplicationDescriptor> appDesc;
    private final LocalJobPlanner planner;
    private final Set<StreamProcessor> processors = ConcurrentHashMap.newKeySet();
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private final AtomicInteger numProcessorsToStart = new AtomicInteger();
    private final AtomicReference<Throwable> failure = new AtomicReference();
    private ApplicationStatus appStatus = ApplicationStatus.New;

    public LocalApplicationRunner(SamzaApplication app, Config config) {
        this.appDesc = ApplicationDescriptorUtil.getAppDescriptor(app, config);
        this.planner = new LocalJobPlanner(this.appDesc);
    }

    @VisibleForTesting
    LocalApplicationRunner(ApplicationDescriptorImpl<? extends ApplicationDescriptor> appDesc, LocalJobPlanner planner) {
        this.appDesc = appDesc;
        this.planner = planner;
    }

    public void run() {
        try {
            List<JobConfig> jobConfigs = this.planner.prepareJobs();
            if (jobConfigs.isEmpty()) {
                throw new SamzaException("No jobs to run.");
            }
            jobConfigs.forEach(jobConfig -> {
                LOG.debug("Starting job {} StreamProcessor with config {}", jobConfig.getName(), jobConfig);
                StreamProcessor processor = this.createStreamProcessor((Config)jobConfig, this.appDesc, sp2 -> new LocalStreamProcessorLifecycleListener(sp2, (Config)jobConfig));
                this.processors.add(processor);
            });
            this.numProcessorsToStart.set(this.processors.size());
            this.processors.forEach(StreamProcessor::start);
        }
        catch (Throwable throwable) {
            this.appStatus = ApplicationStatus.unsuccessfulFinish((Throwable)throwable);
            this.shutdownLatch.countDown();
            throw new SamzaException(String.format("Failed to start application: %s", new ApplicationConfig(this.appDesc.getConfig()).getGlobalAppId()), throwable);
        }
    }

    public void kill() {
        this.processors.forEach(StreamProcessor::stop);
    }

    public ApplicationStatus status() {
        return this.appStatus;
    }

    public void waitForFinish() {
        this.waitForFinish(Duration.ofSeconds(0L));
    }

    public boolean waitForFinish(Duration timeout) {
        long timeoutInMs = timeout.toMillis();
        boolean finished = true;
        try {
            if (timeoutInMs < 1L) {
                this.shutdownLatch.await();
            } else {
                finished = this.shutdownLatch.await(timeoutInMs, TimeUnit.MILLISECONDS);
                if (!finished) {
                    LOG.warn("Timed out waiting for application to finish.");
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error waiting for application to finish", (Throwable)e);
            throw new SamzaException((Throwable)e);
        }
        return finished;
    }

    @VisibleForTesting
    protected Set<StreamProcessor> getProcessors() {
        return Collections.unmodifiableSet(this.processors);
    }

    @VisibleForTesting
    CountDownLatch getShutdownLatch() {
        return this.shutdownLatch;
    }

    @VisibleForTesting
    StreamProcessor createStreamProcessor(Config config, ApplicationDescriptorImpl<? extends ApplicationDescriptor> appDesc, StreamProcessor.StreamProcessorLifecycleListenerFactory listenerFactory) {
        TaskFactory taskFactory = TaskFactoryUtil.getTaskFactory(appDesc);
        HashMap<String, MetricsReporter> reporters = new HashMap<String, MetricsReporter>();
        appDesc.getMetricsReporterFactories().forEach((name, factory) -> reporters.put((String)name, factory.getMetricsReporter(name, null, config)));
        return new StreamProcessor(config, reporters, taskFactory, appDesc.getApplicationContainerContextFactory(), appDesc.getApplicationTaskContextFactory(), listenerFactory, null);
    }

    private final class LocalStreamProcessorLifecycleListener
    implements ProcessorLifecycleListener {
        private final StreamProcessor processor;
        private final ProcessorLifecycleListener userDefinedProcessorLifecycleListener;

        LocalStreamProcessorLifecycleListener(StreamProcessor processor, Config jobConfig) {
            this.userDefinedProcessorLifecycleListener = LocalApplicationRunner.this.appDesc.getProcessorLifecycleListenerFactory().createInstance(new ProcessorContext(){}, jobConfig);
            this.processor = processor;
        }

        public void beforeStart() {
            this.userDefinedProcessorLifecycleListener.beforeStart();
        }

        public void afterStart() {
            if (LocalApplicationRunner.this.numProcessorsToStart.decrementAndGet() == 0) {
                LocalApplicationRunner.this.appStatus = ApplicationStatus.Running;
            }
            this.userDefinedProcessorLifecycleListener.afterStart();
        }

        public void afterStop() {
            LocalApplicationRunner.this.processors.remove(this.processor);
            this.handleProcessorShutdown(null);
        }

        public void afterFailure(Throwable t) {
            LocalApplicationRunner.this.processors.remove(this.processor);
            if (LocalApplicationRunner.this.failure.compareAndSet(null, t)) {
                LocalApplicationRunner.this.processors.forEach(StreamProcessor::stop);
            }
            this.handleProcessorShutdown(t);
        }

        private void handleProcessorShutdown(Throwable error) {
            if (LocalApplicationRunner.this.processors.isEmpty()) {
                this.setApplicationFinalStatus();
            }
            if (error != null) {
                this.userDefinedProcessorLifecycleListener.afterFailure(error);
            } else {
                this.userDefinedProcessorLifecycleListener.afterStop();
            }
            if (LocalApplicationRunner.this.processors.isEmpty()) {
                LocalApplicationRunner.this.shutdownLatch.countDown();
            }
        }

        private void setApplicationFinalStatus() {
            if (LocalApplicationRunner.this.failure.get() != null) {
                LocalApplicationRunner.this.appStatus = ApplicationStatus.unsuccessfulFinish((Throwable)((Throwable)LocalApplicationRunner.this.failure.get()));
            } else if (LocalApplicationRunner.this.appStatus == ApplicationStatus.Running) {
                LocalApplicationRunner.this.appStatus = ApplicationStatus.SuccessfulFinish;
            } else if (LocalApplicationRunner.this.appStatus == ApplicationStatus.New) {
                LocalApplicationRunner.this.appStatus = ApplicationStatus.UnsuccessfulFinish;
            }
        }
    }
}

