/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.runtime;

import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.samza.application.ApplicationUtil;
import org.apache.samza.application.SamzaApplication;
import org.apache.samza.config.Config;
import org.apache.samza.config.MapConfig;
import org.apache.samza.runtime.ApplicationRunner;
import org.apache.samza.runtime.ApplicationRunnerOperation;
import org.apache.samza.runtime.ApplicationRunners;
import org.apache.samza.util.CommandLine;
import org.apache.samza.util.Util;

public class ApplicationRunnerMain {
    public static void main(String[] args) throws Exception {
        ApplicationRunnerCommandLine cmdLine = new ApplicationRunnerCommandLine();
        OptionSet options = cmdLine.parser().parse(args);
        MapConfig orgConfig = cmdLine.loadConfig(options);
        Config config = Util.rewriteConfig((Config)orgConfig);
        ApplicationRunnerOperation op = cmdLine.getOperation(options);
        ApplicationRunner appRunner = ApplicationRunners.getApplicationRunner((SamzaApplication)ApplicationUtil.fromConfig(config), (Config)config);
        switch (op) {
            case RUN: {
                appRunner.run();
                break;
            }
            case KILL: {
                appRunner.kill();
                break;
            }
            case STATUS: {
                System.out.println(appRunner.status());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized operation: " + (Object)((Object)op));
            }
        }
    }

    public static class ApplicationRunnerCommandLine
    extends CommandLine {
        public OptionSpec operationOpt = this.parser().accepts("operation", "The operation to perform; run, status, kill.").withRequiredArg().ofType(String.class).describedAs("operation=run").defaultsTo((Object)"run", (Object[])new String[0]);

        public ApplicationRunnerOperation getOperation(OptionSet options) {
            String rawOp = options.valueOf(this.operationOpt).toString();
            return ApplicationRunnerOperation.fromString(rawOp);
        }
    }
}

